/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.util;

import com.nvidia.cuda.ide.editor.Activator;
import com.nvidia.cuda.ide.util.IDebuggerInstanceDetector;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class NsightUtil {
    private static final String CUDA_GDB_LOCKFILE = "cuda-dbg/cuda-gdb.lock";

    private static Boolean detectUsingExtensions() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.nvidia.cuda.ide.editor", "debuggerDetectors");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Boolean test = NsightUtil.runExtension(element);
            if (!Boolean.FALSE.equals(test)) {
                return test;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isCudaGdbLockFileLocked() {
        try {
            File file = NsightUtil.findCudaGdbLockFile();
            return file.isFile() && NsightUtil.isLocked(file);
        }
        catch (IOException e) {
            Activator.log(e);
            return false;
        }
    }

    private static boolean isLocked(File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        FileLock lock = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel channel = randomAccessFile.getChannel();
            lock = channel.tryLock();
            boolean bl = lock == null;
            return bl;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
    }

    private static File findCudaGdbLockFile() {
        File file = new File("/tmp", CUDA_GDB_LOCKFILE);
        if (!file.isFile()) {
            file = new File(System.getProperty("java.io.tmpdir", "/tmp"), CUDA_GDB_LOCKFILE);
        }
        return file;
    }

    public static Boolean isCudaGdbRunning(boolean quiet) throws CoreException {
        Boolean detected = NsightUtil.detectUsingExtensions();
        if (Boolean.FALSE.equals(detected)) {
            return NsightUtil.wasStandaloneCudaGdbInstance(quiet);
        }
        return detected;
    }

    private static Boolean runExtension(IConfigurationElement element) {
        try {
            Object extension = element.createExecutableExtension("class");
            if (extension instanceof IDebuggerInstanceDetector) {
                return ((IDebuggerInstanceDetector)extension).detect();
            }
            Activator.log(String.format("Debugger instance detector %s contributed by %s should implement %s", extension, element.getContributor().getName(), IDebuggerInstanceDetector.class), null);
        }
        catch (CoreException e) {
            Activator.log(element.getContributor().getName(), e);
        }
        return false;
    }

    private static boolean wasStandaloneCudaGdbInstance(boolean quiet) throws CoreException {
        if (NsightUtil.isCudaGdbLockFileLocked()) {
            if (!quiet) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        MessageBox box = new MessageBox(workbenchWindow.getShell(), 1);
                        box.setText("Device in Use");
                        box.setMessage("Another instance of cuda-gdb is using the device. Quit other cuda-gdb instances before launching the application\n\nIf you believe you are seeing this message in error, try deleting /tmp/cuda-dbg/cuda-gdb.lock.");
                        box.open();
                    }
                });
            }
            return true;
        }
        return false;
    }

    private NsightUtil() {
    }

    public static Shell getDefaultParentShell() {
        if (Display.getCurrent() == null) {
            final Shell[] reference = new Shell[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    reference[0] = NsightUtil.getDefaultParentShell();
                }
            });
            return reference[0];
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void clearAllDialogToggles() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.nvidia.cuda.ide.editor", "togglePreferences");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String pluginId = element.getAttribute("plugin-id");
            if (pluginId == null) {
                pluginId = element.getContributor().getName();
            }
            String preferenceName = element.getAttribute("preference");
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, pluginId);
            store.setToDefault(preferenceName);
            try {
                store.save();
            }
            catch (IOException e) {
                Activator.log(e);
            }
            ++n2;
        }
    }
}

