/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableFolderSyncInfo;

class StaticHandler
extends ResponseHandler {
    private final boolean setStaticDirectory;

    public StaticHandler(boolean setStaticDirectory) {
        this.setStaticDirectory = setStaticDirectory;
    }

    public String getResponseID() {
        if (this.setStaticDirectory) {
            return "Set-static-directory";
        }
        return "Clear-static-directory";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        block4: {
            String repositoryDir = session.readLine();
            Assert.isTrue((boolean)repositoryDir.endsWith("/"));
            repositoryDir = repositoryDir.substring(0, repositoryDir.length() - 1);
            try {
                ICVSFolder folder = StaticHandler.createFolder(session, localDir, repositoryDir);
                FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
                if (syncInfo == null) {
                    return;
                }
                MutableFolderSyncInfo newInfo = syncInfo.cloneMutable();
                newInfo.setStatic(this.setStaticDirectory);
                if (!syncInfo.equals(newInfo)) {
                    folder.setFolderSyncInfo(newInfo);
                }
            }
            catch (CVSException e) {
                if (this.handleInvalidResourceName(session, session.getLocalRoot().getFolder(localDir), e)) break block4;
                throw e;
            }
        }
    }
}

