/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;

public class GarbageCollectOperation
implements IEGitOperation {
    private Repository repository;

    public GarbageCollectOperation(Repository repository) {
        this.repository = repository;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        Git git = new Git(this.repository);
        EclipseGitProgressTransformer pm = new EclipseGitProgressTransformer(monitor);
        try {
            git.gc().setProgressMonitor((ProgressMonitor)pm).call();
        }
        catch (GitAPIException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

