/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.refactoring;

import com.nvidia.cuda.ide.language.ast.CudaCASTUtil;
import com.nvidia.cuda.ide.language.ast.CudaTarget;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExpressionExtractor;

public class CudaExpressionExtractor
extends ExpressionExtractor {
    public static IASTDeclSpecifier fixCodeTarget(IASTNode extractedNode, IASTDeclSpecifier returnType) {
        short extendedBits = CudaExpressionExtractor.getExtendedBits(extractedNode);
        returnType.setExtendedBits(extendedBits);
        return returnType;
    }

    private static short getExtendedBits(IASTNode node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof ICPPASTFunctionDefinition) {
            IASTDeclSpecifier declSpecifier = ((ICPPASTFunctionDefinition)node).getDeclSpecifier();
            CudaTarget target = CudaCASTUtil.getTarget((Object)declSpecifier);
            return target == CudaTarget.cudaHost ? (short)0 : target.bits;
        }
        return CudaExpressionExtractor.getExtendedBits(node.getParent());
    }

    public IASTDeclSpecifier determineReturnType(IASTNode extractedNode, NameInformation returnVariable, List<IASTPointerOperator> pointerOperators) {
        return CudaExpressionExtractor.fixCodeTarget(extractedNode, super.determineReturnType(extractedNode, returnVariable, pointerOperators));
    }
}

