/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.index;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.util.BasicUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.provider.IPDOMDescriptor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class CudaSDKPDOMDescriptor
implements IPDOMDescriptor,
IIndexLocationConverter {
    private final IPath location;
    public static final String SDK_VAR = "$(CUDA_SDK_INCLUDE_PATH)";
    private static File cudaIncludePath = null;
    private HashMap<String, IIndexFileLocation> indexMap = new HashMap();

    private static File getCudaIncludeDir() {
        if (cudaIncludePath == null) {
            File includeFile;
            String includePath = BasicUtil.performStringSubstitution("${cuda_bin}/../include");
            File file = includeFile = includePath != null ? new File(includePath) : null;
            if (BasicUtil.isDirectory(includeFile)) {
                try {
                    cudaIncludePath = includeFile.getCanonicalFile();
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            }
        }
        return cudaIncludePath;
    }

    public CudaSDKPDOMDescriptor(IPath path) {
        this.location = path;
    }

    public IPath getLocation() {
        return this.location;
    }

    public IIndexLocationConverter getIndexLocationConverter() {
        return this;
    }

    private IIndexFileLocation createIndexFromInternalLocation(String raw) {
        URI uri;
        if (raw == null) {
            return null;
        }
        if (raw.startsWith(SDK_VAR)) {
            File includeDir = CudaSDKPDOMDescriptor.getCudaIncludeDir();
            File includeFile = includeDir != null ? new File(includeDir, raw.substring(SDK_VAR.length())) : null;
            uri = BasicUtil.isFile(includeFile) ? includeFile.toURI() : null;
        } else {
            try {
                uri = new URI(raw);
            }
            catch (URISyntaxException e) {
                Activator.log(e);
                return null;
            }
        }
        return uri != null ? new IIndexFileLocationImplementation(uri) : null;
    }

    public IIndexFileLocation fromInternalFormat(String raw) {
        if (raw == null) {
            return null;
        }
        if (!this.indexMap.containsKey(raw)) {
            this.indexMap.put(raw, this.createIndexFromInternalLocation(raw));
        }
        return this.indexMap.get(raw);
    }

    public String toInternalFormat(IIndexFileLocation location) {
        URI uri;
        if (location.getFullPath() == null && "file".equals((uri = location.getURI()).getScheme())) {
            String path = uri.getPath();
            return new Path(SDK_VAR).append(new Path(path).lastSegment()).toString();
        }
        return null;
    }

    private final class IIndexFileLocationImplementation
    implements IIndexFileLocation {
        private final URI uri;

        private IIndexFileLocationImplementation(URI uri) {
            this.uri = uri;
        }

        public URI getURI() {
            return this.uri;
        }

        public String getFullPath() {
            return null;
        }

        public int hashCode() {
            return this.uri != null ? this.uri.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IIndexFileLocationImplementation other = (IIndexFileLocationImplementation)obj;
            return this.uri != null ? this.uri.equals(other.uri) : other.uri == this.uri;
        }
    }
}

