/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.ui;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.project.ICubinModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import com.nvidia.cuda.ide.build.project.ProjectMetaManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public final class CudaCLabelDecorator
implements ILightweightLabelDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFile) {
            IFile resource = (IFile)element;
            ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
            ICProjectDescription desc = mngr.getProjectDescription(resource.getProject(), false);
            if (desc == null) {
                return;
            }
            ICConfigurationDescription conf = desc.getDefaultSettingConfiguration();
            ICSourceEntry[] entries = conf.getSourceEntries();
            boolean isSource = false;
            ICSourceEntry[] iCSourceEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ICSourceEntry icSourceEntry = iCSourceEntryArray[n2];
                if (icSourceEntry.getFullPath().isPrefixOf(resource.getFullPath())) {
                    isSource = true;
                    break;
                }
                ++n2;
            }
            try {
                if (isSource) {
                    ICudaProjectConfiguration configuration = ProjectMetaManager.load(desc.getActiveConfiguration());
                    ICubinModule[] modules = configuration.getModules();
                    boolean needsComma = false;
                    StringBuilder builder = new StringBuilder();
                    ICubinModule[] iCubinModuleArray = modules;
                    int n3 = modules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICubinModule module = iCubinModuleArray[n4];
                        if (module.includes(resource)) {
                            if (needsComma) {
                                builder.append(", ");
                            }
                            builder.append(module.getPath().lastSegment());
                            needsComma = true;
                        }
                        ++n4;
                    }
                    if (builder.length() > 0) {
                        decoration.addSuffix(String.format(" [%s]", builder));
                    }
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }
}

