/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;
import org.eclipse.tm.internal.terminal.emulator.IVT100EmulatorBackend;
import org.eclipse.tm.internal.terminal.emulator.VT100BackendTraceDecorator;
import org.eclipse.tm.internal.terminal.emulator.VT100EmulatorBackend;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.Style;

public class VT100Emulator
implements ControlListener {
    private static final int ANSISTATE_INITIAL = 0;
    private static final int ANSISTATE_ESCAPE = 1;
    private static final int ANSISTATE_EXPECTING_PARAMETER_OR_COMMAND = 2;
    private static final int ANSISTATE_EXPECTING_OS_COMMAND = 3;
    private int ansiState = 0;
    private final ITerminalControlForText terminal;
    private final IVT100EmulatorBackend text;
    private int savedCursorLine = 0;
    private int savedCursorColumn = 0;
    private final StringBuffer[] ansiParameters = new StringBuffer[16];
    private final StringBuffer ansiOsCommand = new StringBuffer(128);
    private int nextAnsiParameter = 0;
    Reader fReader;
    boolean fCrAfterNewLine;
    private int fNextChar = -1;

    public VT100Emulator(ITerminalTextData data, ITerminalControlForText terminal, Reader reader) {
        Logger.log("entered");
        this.terminal = terminal;
        int i = 0;
        while (i < this.ansiParameters.length) {
            this.ansiParameters[i] = new StringBuffer();
            ++i;
        }
        this.setInputStreamReader(reader);
        this.text = TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/VT100Backend") ? new VT100BackendTraceDecorator(new VT100EmulatorBackend(data), System.out) : new VT100EmulatorBackend(data);
        Style style = Style.getStyle("BLACK", "WHITE");
        this.text.setDefaultStyle(style);
        this.text.setStyle(style);
    }

    public void setInputStreamReader(Reader reader) {
        this.fReader = reader;
    }

    public void setDimensions(int lines, int cols) {
        this.text.setDimensions(lines, cols);
        ITerminalConnector telnetConnection = this.getConnector();
        if (telnetConnection != null) {
            telnetConnection.setTerminalSize(this.text.getColumns(), this.text.getLines());
        }
    }

    public void dispose() {
    }

    public void controlMoved(ControlEvent event) {
        Logger.log("entered");
    }

    public void controlResized(ControlEvent event) {
        Logger.log("entered");
        this.adjustTerminalDimensions();
    }

    public void clearTerminal() {
        Logger.log("entered");
        this.text.clearAll();
    }

    public void fontChanged() {
        Logger.log("entered");
        if (this.text != null) {
            this.adjustTerminalDimensions();
        }
    }

    public void processText() {
        try {
            this.adjustTerminalDimensions();
            try {
                this.processNewText();
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        catch (Exception ex) {
            Logger.logException(ex);
        }
    }

    private void processNewText() throws IOException {
        Logger.log("entered");
        block22: while (this.hasNextChar()) {
            char character = this.getNextChar();
            switch (this.ansiState) {
                case 0: {
                    switch (character) {
                        case '\u0000': {
                            break;
                        }
                        case '\u0007': {
                            this.processBEL();
                            break;
                        }
                        case '\b': {
                            this.processBackspace();
                            break;
                        }
                        case '\t': {
                            this.processTab();
                            break;
                        }
                        case '\n': {
                            this.processNewline();
                            if (!this.fCrAfterNewLine) continue block22;
                            this.processCarriageReturn();
                            break;
                        }
                        case '\r': {
                            this.processCarriageReturn();
                            break;
                        }
                        case '\u001b': {
                            this.ansiState = 1;
                            break;
                        }
                        default: {
                            this.processNonControlCharacters(character);
                            break;
                        }
                    }
                    continue block22;
                }
                case 1: {
                    switch (character) {
                        case '[': {
                            this.ansiState = 2;
                            this.nextAnsiParameter = 0;
                            int i = 0;
                            while (i < this.ansiParameters.length) {
                                this.ansiParameters[i].delete(0, this.ansiParameters[i].length());
                                ++i;
                            }
                            continue block22;
                        }
                        case ']': {
                            this.ansiState = 3;
                            this.ansiOsCommand.delete(0, this.ansiOsCommand.length());
                            break;
                        }
                        case '7': {
                            this.ansiState = 0;
                            this.savedCursorLine = this.relativeCursorLine();
                            this.savedCursorColumn = this.getCursorColumn();
                            break;
                        }
                        case '8': {
                            this.ansiState = 0;
                            this.moveCursor(this.savedCursorLine, this.savedCursorColumn);
                            break;
                        }
                        case 'c': {
                            this.ansiState = 0;
                            this.resetTerminal();
                            break;
                        }
                        default: {
                            Logger.log("Unsupported escape sequence: escape '" + character + "'");
                            this.ansiState = 0;
                            break;
                        }
                    }
                    continue block22;
                }
                case 2: {
                    if (character == '@' || character >= 'A' && character <= 'Z' || character >= 'a' && character <= 'z') {
                        this.ansiState = 0;
                        this.processAnsiCommandCharacter(character);
                        break;
                    }
                    this.processAnsiParameterCharacter(character);
                    break;
                }
                case 3: {
                    if (character == '\u0007') {
                        this.ansiState = 0;
                        this.processAnsiOsCommand();
                        break;
                    }
                    this.ansiOsCommand.append(character);
                    break;
                }
                default: {
                    Logger.log("INVALID ANSI FSA STATE: " + this.ansiState);
                    this.ansiState = 0;
                }
            }
        }
    }

    private void resetTerminal() {
        this.text.eraseAll();
        this.text.setCursor(0, 0);
        this.text.setStyle(this.text.getDefaultStyle());
    }

    private void processAnsiOsCommand() {
        if (this.ansiOsCommand.charAt(0) != '0' || this.ansiOsCommand.charAt(1) != ';') {
            Logger.log("Ignoring unsupported ANSI OSC sequence: '" + this.ansiOsCommand + "'");
            return;
        }
        this.terminal.setTerminalTitle(this.ansiOsCommand.substring(2));
    }

    private void processAnsiCommandCharacter(char ansiCommandCharacter) {
        switch (ansiCommandCharacter) {
            case '@': {
                this.processAnsiCommand_atsign();
                break;
            }
            case 'A': {
                this.processAnsiCommand_A();
                break;
            }
            case 'B': {
                this.processAnsiCommand_B();
                break;
            }
            case 'C': {
                this.processAnsiCommand_C();
                break;
            }
            case 'D': {
                this.processAnsiCommand_D();
                break;
            }
            case 'E': {
                this.processAnsiCommand_E();
                break;
            }
            case 'F': {
                this.processAnsiCommand_F();
                break;
            }
            case 'G': {
                this.processAnsiCommand_G();
                break;
            }
            case 'H': {
                this.processAnsiCommand_H();
                break;
            }
            case 'J': {
                this.processAnsiCommand_J();
                break;
            }
            case 'K': {
                this.processAnsiCommand_K();
                break;
            }
            case 'L': {
                this.processAnsiCommand_L();
                break;
            }
            case 'M': {
                this.processAnsiCommand_M();
                break;
            }
            case 'm': {
                this.processAnsiCommand_m();
                break;
            }
            case 'n': {
                this.processAnsiCommand_n();
                break;
            }
            case 'P': {
                this.processAnsiCommand_P();
                break;
            }
            case 'S': {
                break;
            }
            case 'T': {
                break;
            }
            case 'X': {
                break;
            }
            case 'Z': {
                break;
            }
            default: {
                Logger.log("Ignoring unsupported ANSI command character: '" + ansiCommandCharacter + "'");
            }
        }
    }

    private void processAnsiCommand_atsign() {
        int charactersToInsert = this.getAnsiParameter(0);
        this.text.insertCharacters(charactersToInsert);
    }

    private void processAnsiCommand_A() {
        this.moveCursorUp(this.getAnsiParameter(0));
    }

    private void processAnsiCommand_B() {
        this.moveCursorDown(this.getAnsiParameter(0));
    }

    private void processAnsiCommand_C() {
        this.moveCursorForward(this.getAnsiParameter(0));
    }

    private void processAnsiCommand_D() {
        this.moveCursorBackward(this.getAnsiParameter(0));
    }

    private void processAnsiCommand_E() {
        int linesToMove = this.getAnsiParameter(0);
        this.moveCursor(this.relativeCursorLine() + linesToMove, 0);
    }

    private void processAnsiCommand_F() {
        int linesToMove = this.getAnsiParameter(0);
        this.moveCursor(this.relativeCursorLine() - linesToMove, 0);
    }

    private void processAnsiCommand_G() {
        this.moveCursor(this.relativeCursorLine(), this.getAnsiParameter(0) - 1);
    }

    private void processAnsiCommand_H() {
        this.moveCursor(this.getAnsiParameter(0) - 1, this.getAnsiParameter(1) - 1);
    }

    private void processAnsiCommand_J() {
        int ansiParameter = this.ansiParameters[0].length() == 0 ? 0 : this.getAnsiParameter(0);
        switch (ansiParameter) {
            case 0: {
                this.text.eraseToEndOfScreen();
                break;
            }
            case 1: {
                this.text.eraseToCursor();
                break;
            }
            case 2: {
                this.text.eraseAll();
                break;
            }
            default: {
                Logger.log("Unexpected J-command parameter: " + ansiParameter);
            }
        }
    }

    private void processAnsiCommand_K() {
        int ansiParameter = 0;
        if (this.ansiParameters[0].length() > 0) {
            ansiParameter = this.getAnsiParameter(0);
        }
        switch (ansiParameter) {
            case 0: {
                this.text.eraseLineToEnd();
                break;
            }
            case 1: {
                this.text.eraseLineToCursor();
                break;
            }
            case 2: {
                this.text.eraseLine();
                break;
            }
            default: {
                Logger.log("Unexpected K-command parameter: " + ansiParameter);
            }
        }
    }

    private void processAnsiCommand_L() {
        this.text.insertLines(this.getAnsiParameter(0));
    }

    private void processAnsiCommand_M() {
        this.text.deleteLines(this.getAnsiParameter(0));
    }

    private void processAnsiCommand_m() {
        if (this.ansiParameters[0].length() == 0) {
            this.ansiParameters[0].append('0');
        }
        Style style = this.text.getStyle();
        int totalParameters = this.ansiParameters.length;
        int parameterIndex = 0;
        while (parameterIndex < totalParameters && this.ansiParameters[parameterIndex].length() > 0) {
            int ansiParameter = this.getAnsiParameter(parameterIndex);
            switch (ansiParameter) {
                case 0: {
                    style = this.text.getDefaultStyle();
                    break;
                }
                case 1: {
                    style = style.setBold(true);
                    break;
                }
                case 4: {
                    style = style.setUnderline(true);
                    break;
                }
                case 5: {
                    style = style.setBlink(true);
                    break;
                }
                case 7: {
                    style = style.setReverse(true);
                    break;
                }
                case 10: {
                    break;
                }
                case 21: 
                case 22: {
                    style = style.setBold(false);
                    break;
                }
                case 24: {
                    style = style.setUnderline(false);
                    break;
                }
                case 25: {
                    style = style.setBlink(false);
                    break;
                }
                case 27: {
                    style = style.setReverse(false);
                    break;
                }
                case 30: {
                    style = style.setForground("BLACK");
                    break;
                }
                case 31: {
                    style = style.setForground("RED");
                    break;
                }
                case 32: {
                    style = style.setForground("GREEN");
                    break;
                }
                case 33: {
                    style = style.setForground("YELLOW");
                    break;
                }
                case 34: {
                    style = style.setForground("BLUE");
                    break;
                }
                case 35: {
                    style = style.setForground("MAGENTA");
                    break;
                }
                case 36: {
                    style = style.setForground("CYAN");
                    break;
                }
                case 37: {
                    style = style.setForground("WHITE_FOREGROUND");
                    break;
                }
                case 39: {
                    style = style.setForground(this.text.getDefaultStyle().getForground());
                    break;
                }
                case 40: {
                    style = style.setBackground("BLACK");
                    break;
                }
                case 41: {
                    style = style.setBackground("RED");
                    break;
                }
                case 42: {
                    style = style.setBackground("GREEN");
                    break;
                }
                case 43: {
                    style = style.setBackground("YELLOW");
                    break;
                }
                case 44: {
                    style = style.setBackground("BLUE");
                    break;
                }
                case 45: {
                    style = style.setBackground("MAGENTA");
                    break;
                }
                case 46: {
                    style = style.setBackground("CYAN");
                    break;
                }
                case 47: {
                    style = style.setBackground("WHITE");
                    break;
                }
                case 49: {
                    style = style.setBackground(this.text.getDefaultStyle().getBackground());
                    break;
                }
                default: {
                    Logger.log("Unsupported graphics rendition parameter: " + ansiParameter);
                }
            }
            ++parameterIndex;
        }
        this.text.setStyle(style);
    }

    private void processAnsiCommand_n() {
        if (this.getAnsiParameter(0) != 6) {
            return;
        }
        String positionReport = "\u001b[" + (this.relativeCursorLine() + 1) + ";" + (this.getCursorColumn() + 1) + "R";
        try {
            OutputStreamWriter streamWriter = new OutputStreamWriter(this.terminal.getOutputStream(), "ISO-8859-1");
            streamWriter.write(positionReport, 0, positionReport.length());
            streamWriter.flush();
        }
        catch (IOException iOException) {
            Logger.log("Caught IOException!");
        }
    }

    private void processAnsiCommand_P() {
        this.text.deleteCharacters(this.getAnsiParameter(0));
    }

    private int getAnsiParameter(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex >= this.ansiParameters.length) {
            return -1;
        }
        String parameter = this.ansiParameters[parameterIndex].toString();
        if (parameter.length() == 0) {
            return 1;
        }
        int parameterValue = 1;
        try {
            parameterValue = Integer.parseInt(parameter);
        }
        catch (NumberFormatException numberFormatException) {
            parameterValue = 1;
        }
        return parameterValue;
    }

    private void processAnsiParameterCharacter(char ch) {
        if (ch == ';') {
            ++this.nextAnsiParameter;
        } else if (this.nextAnsiParameter < this.ansiParameters.length) {
            this.ansiParameters[this.nextAnsiParameter].append(ch);
        }
    }

    private void processNonControlCharacters(char character) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(character);
        while (this.hasNextChar()) {
            character = this.getNextChar();
            if (character == '\u0000' || character == '\b' || character == '\t' || character == '\u0007' || character == '\n' || character == '\r' || character == '\u001b') {
                this.pushBackChar(character);
                break;
            }
            buffer.append(character);
        }
        this.displayNewText(buffer.toString());
    }

    private void displayNewText(String buffer) {
        this.text.appendString(buffer);
    }

    private void processBEL() {
    }

    private void processBackspace() {
        this.moveCursorBackward(1);
    }

    private void processTab() {
        this.moveCursorForward(8 - this.getCursorColumn() % 8);
    }

    private void processNewline() {
        this.text.processNewline();
    }

    private void processCarriageReturn() {
        this.text.setCursorColumn(0);
    }

    private void adjustTerminalDimensions() {
        ITerminalConnector telnetConnection = this.getConnector();
        if (telnetConnection != null) {
            telnetConnection.setTerminalSize(this.text.getColumns(), this.text.getLines());
        }
    }

    private ITerminalConnector getConnector() {
        if (this.terminal.getTerminalConnector() != null) {
            return this.terminal.getTerminalConnector();
        }
        return null;
    }

    private int relativeCursorLine() {
        return this.text.getCursorLine();
    }

    private void moveCursor(int targetLine, int targetColumn) {
        this.text.setCursor(targetLine, targetColumn);
    }

    private void moveCursorDown(int lines) {
        this.moveCursor(this.relativeCursorLine() + lines, this.getCursorColumn());
    }

    private void moveCursorUp(int lines) {
        this.moveCursor(this.relativeCursorLine() - lines, this.getCursorColumn());
    }

    private void moveCursorForward(int columnsToMove) {
        this.moveCursor(this.relativeCursorLine(), this.getCursorColumn() + columnsToMove);
    }

    private void moveCursorBackward(int columnsToMove) {
        this.moveCursor(this.relativeCursorLine(), this.getCursorColumn() - columnsToMove);
    }

    public void resetState() {
        this.ansiState = 0;
        this.text.setStyle(this.text.getDefaultStyle());
    }

    private char getNextChar() throws IOException {
        int c = -1;
        if (this.fNextChar != -1) {
            c = this.fNextChar;
            this.fNextChar = -1;
        } else {
            c = this.fReader.read();
        }
        if (c == -1) {
            c = 0;
        }
        return (char)c;
    }

    private boolean hasNextChar() throws IOException {
        if (this.fNextChar >= 0) {
            return true;
        }
        return this.fReader.ready();
    }

    void pushBackChar(char c) {
        this.fNextChar = c;
    }

    private int getCursorColumn() {
        return this.text.getCursorColumn();
    }

    public boolean isCrAfterNewLine() {
        return this.fCrAfterNewLine;
    }

    public void setCrAfterNewLine(boolean crAfterNewLine) {
        this.fCrAfterNewLine = crAfterNewLine;
    }

    void setVT100LineWrapping(boolean enable) {
        this.text.setVT100LineWrapping(enable);
    }

    boolean isVT100LineWrapping() {
        return this.text.isVT100LineWrapping();
    }
}

