/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;

public class Cube
implements ICube {
    protected String name;
    protected IDocumentManager documentManager;
    protected IDimension[] dimension;
    private FactTable factTable;
    private static Logger logger = Logger.getLogger(Cube.class.getName());

    public Cube(String name, IDocumentManager documentManager) {
        Object[] params = new Object[]{name, documentManager};
        logger.entering(Cube.class.getName(), "Cube", params);
        this.name = name;
        this.documentManager = documentManager;
        logger.exiting(Cube.class.getName(), "Cube");
    }

    public void create(String[][] keyColumnNames, IDimension[] dimension, IDatasetIterator iterator, String[] measureColumnName, long cacheSize, StopSign stopSign) throws IOException, BirtException {
        this.create(keyColumnNames, keyColumnNames, dimension, iterator, measureColumnName, cacheSize, stopSign);
    }

    public void create(String[][] keyColumnNames, IDimension[] dimension, IDatasetIterator iterator, String[] measureColumnName, StopSign stopSign) throws IOException, BirtException {
        this.create(keyColumnNames, keyColumnNames, dimension, iterator, measureColumnName, 0L, stopSign);
    }

    public void create(String[][] factTableJointColumnNames, String[][] DimJointColumnNames, IDimension[] dimension, IDatasetIterator iterator, String[] measureColumnName, Map calculatedMeasure, String[] measureColumnAggregations, long cacheSize, StopSign stopSign) throws IOException, BirtException {
        IDocumentObject documentObject = this.documentManager.createDocumentObject(NamingUtil.getCubeDocName(this.name));
        documentObject.writeString(this.name);
        documentObject.writeInt(dimension.length);
        int i = 0;
        while (i < dimension.length) {
            documentObject.writeString(dimension[i].getName());
            ++i;
        }
        this.dimension = dimension;
        Dimension[] tDimensions = new Dimension[dimension.length];
        int i2 = 0;
        while (i2 < tDimensions.length) {
            tDimensions[i2] = (Dimension)dimension[i2];
            ++i2;
        }
        FactTableAccessor factTableConstructor = new FactTableAccessor(this.documentManager);
        factTableConstructor.setMemoryCacheSize(cacheSize);
        this.factTable = factTableConstructor.saveFactTable(this.name, factTableJointColumnNames, DimJointColumnNames, iterator, tDimensions, measureColumnName, calculatedMeasure, measureColumnAggregations, stopSign);
        documentObject.close();
        this.documentManager.flush();
    }

    public void create(String[][] factTableJointColumnNames, String[][] DimJointColumnNames, IDimension[] dimension, IDatasetIterator iterator, String[] measureColumnName, long cacheSize, StopSign stopSign) throws IOException, BirtException {
        this.create(factTableJointColumnNames, DimJointColumnNames, dimension, iterator, measureColumnName, null, null, cacheSize, stopSign);
    }

    public void load(StopSign stopSign) throws IOException, DataException {
        IDocumentObject documentObject = this.documentManager.openDocumentObject(NamingUtil.getCubeDocName(this.name));
        if (documentObject == null) {
            throw new DataException("data.olap.DocumentObjectNotExists", new Object[]{this.name});
        }
        documentObject.seek(0L);
        this.name = documentObject.readString();
        this.dimension = new IDimension[documentObject.readInt()];
        int i = 0;
        while (i < this.dimension.length) {
            String name = documentObject.readString();
            this.dimension[i] = this.loadDimension(name);
            ++i;
        }
        FactTableAccessor factTableConstructor = new FactTableAccessor(this.documentManager);
        this.factTable = factTableConstructor.load(this.name, stopSign);
        documentObject.close();
    }

    protected IDimension loadDimension(String name) throws DataException, IOException {
        return DimensionFactory.loadDimension(name, this.documentManager);
    }

    @Override
    public IDimension[] getDimesions() {
        return this.dimension;
    }

    public FactTable getFactTable() {
        return this.factTable;
    }

    @Override
    public void close() throws IOException {
        int i = 0;
        while (i < this.dimension.length) {
            this.dimension[i].close();
            ++i;
        }
    }

    @Override
    public String[] getMeasureNames() {
        return this.factTable.getMeasureNames();
    }
}

