/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.view;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class PresentationPropertyAction
extends Action
implements IPropertyChangeListener {
    private final TreeModelViewer viewer;
    private final String property;
    private final String value;
    private final boolean canBeNull;

    public PresentationPropertyAction(TreeModelViewer viewer, String property, String value, boolean canBeNull, String id, String label, String description, ImageDescriptor image) {
        super(label, 8);
        this.viewer = viewer;
        this.property = property;
        this.value = value;
        this.canBeNull = canBeNull;
        this.setId(id);
        this.setImageDescriptor(image);
        this.setDescription(description);
        this.setToolTipText(description);
        viewer.getPresentationContext().addPropertyChangeListener((IPropertyChangeListener)this);
        this.refresh();
    }

    private void refresh() {
        String v = (String)this.viewer.getPresentationContext().getProperty(this.property);
        this.setChecked(v == null && this.canBeNull || this.value.equals(v));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.property.equals(event.getProperty())) {
            this.refresh();
        }
    }

    public void run() {
        IPresentationContext presentationContext = this.viewer.getPresentationContext();
        presentationContext.setProperty("noselectiontracking", (Object)true);
        presentationContext.setProperty(this.property, (Object)this.value);
        presentationContext.setProperty("noselectiontracking", (Object)false);
    }

    public void dispose() {
        this.viewer.getPresentationContext().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

