/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.SmVMNode;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.CudaObjectLabelImage;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.OccupancyImage;
import com.nvidia.cuda.ide.debug.util.RIRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.ui.IMemento;

public final class WarpVMNode
extends AbstractCudaDMVMNode<Warp> {
    public WarpVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, Warp.class);
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createLabelColumn());
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#Inactive|1#1 active lane|1<{0} active lanes}{1,choice,0#|1# and {1} divergent lanes}", new String[]{"active_lane", "divergent_lanes"}), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false), new OccupancyImage("total.lanes", "active_lane", "divergent_lanes")}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#|1#Kernel {1} Block {2}}", new String[]{"is_active_i", "kernel_id", "block_id"})}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createLabelColumn());
        return provider;
    }

    private LabelColumnInfo createLabelColumn() {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("Warp {0}", new String[]{"id"}), new CudaObjectLabelImage(CudaDebugImages.WARP, CudaDebugImages.WARP_INACTIVE), new ConditionalLabelColors(DebugUtil.getRGBColor(33), "cuda_object_active", false)});
    }

    @Override
    protected boolean isLogicalNode() {
        return false;
    }

    @Override
    protected void updatePropertiesInSessionThread(Warp element, IPropertiesUpdate update) {
        update.setProperty("id", (Object)element.getId());
        update.setProperty("total.lanes", (Object)((Device)DMContexts.getAncestorOfType((IDMContext)element, Device.class)).getLaneCount());
        RIRequestMonitor.fill(update, this.getExecutor(), element, (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class));
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        return MessageFormat.format((String)"{0,choice,1#Inactive|1<{0} Inactive Warps}", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart() + 1L});
    }

    @Override
    protected String getInactiveElementRangeLabel(RangeContext rangeContext, boolean singleColumn) {
        return MessageFormat.format((String)"{0,choice,1#Warp {1}|1<Warps {1} - {2}}", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart(), rangeContext.getStart(), rangeContext.getEnd()});
    }

    @Override
    protected boolean compareElement(Warp object, IMemento memento) {
        return WarpVMNode.compareWarps(object, memento);
    }

    public static boolean compareWarps(Warp object, IMemento memento) {
        return object != null && SmVMNode.compareSms((StreamingMultiprocessor)DMContexts.getParentOfType((IDMContext)object, StreamingMultiprocessor.class), memento) && Integer.valueOf(object.getId()).equals(memento.getInteger("warp_id"));
    }

    @Override
    protected void encodeElement(Warp object, IMemento memento) {
        WarpVMNode.encodeWarp(object, memento);
    }

    public static void encodeWarp(Warp object, IMemento memento) {
        if (object != null) {
            SmVMNode.encodeSM((StreamingMultiprocessor)DMContexts.getAncestorOfType((IDMContext)object, StreamingMultiprocessor.class), memento);
            memento.putInteger("warp_id", (int)object.getId());
        }
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.WARP_INACTIVE;
    }
}

