/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaBackend;
import com.nvidia.cuda.ide.debug.service.ICudaGdbOptions;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CudaBreakpointsManager
extends MIBreakpointsManager
implements IPropertyChangeListener {
    public CudaBreakpointsManager(DsfSession session, String debugModelId) {
        super(session, debugModelId);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), rm){

            protected void handleSuccess() {
                CudaBreakpointsManager.this.initializeCudaFeatures(rm);
            }
        });
    }

    protected void initializeCudaFeatures(RequestMonitor rm) {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        String value = this.getPreferenceStore().getString("break_on_launch");
        if (value == null || value.trim().length() == 0) {
            value = "none";
        }
        this.enableKernelBreakpoints(value);
        rm.done();
    }

    private IPreferenceStore getPreferenceStore() {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            return activator.getPreferenceStore();
        }
        return null;
    }

    public void shutdown(final RequestMonitor rm) {
        super.shutdown(new RequestMonitor(ImmediateExecutor.getInstance(), rm){

            protected void handleSuccess() {
                CudaBreakpointsManager.this.shutdownCudaFeatures(rm);
            }
        });
    }

    protected void shutdownCudaFeatures(RequestMonitor rm) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        rm.done();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("break_on_launch".equals(event.getProperty())) {
            String value = event.getNewValue().toString();
            this.enableKernelBreakpoints(value);
        }
    }

    private void enableKernelBreakpoints(String value) {
        IMIProcesses processes = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
        IMICommandControl control = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        CudaBackend backend = (CudaBackend)((Object)this.getServicesTracker().getService(CudaBackend.class));
        boolean restoreDeferedMode = !(!"none".equals(value) && !CoreUtil.isNullOrEmpty((String)value) || backend != null && backend.isKernelNotificationsEnabled());
        runControl.executeWithTargetAvailable((IDMContext)processes.createContainerContextFromThreadId(control.getContext(), null), new Sequence.Step[]{new SetKernelLaunchBreakStep(value, control, restoreDeferedMode)}, new RequestMonitor(ImmediateExecutor.getInstance(), null));
    }

    private final class SetKernelLaunchBreakStep
    extends Sequence.Step {
        private final String value;
        private final IMICommandControl control;
        private final boolean restoreDeferredMode;

        public SetKernelLaunchBreakStep(String value, IMICommandControl control, boolean restoreDeferredMode) {
            this.value = value;
            this.control = control;
            this.restoreDeferredMode = restoreDeferredMode;
        }

        public void execute(RequestMonitor rm) {
            CommandFactory commandFactory = this.control.getCommandFactory();
            ICommandControlService.ICommandControlDMContext ctx = this.control.getContext();
            ICommand<MIInfo> commandBreak = ICudaGdbOptions.createCommand(commandFactory, (IDMContext)ctx, "break_on_launch", this.value);
            this.control.queueCommand(commandBreak, new DataRequestMonitor((Executor)CudaBreakpointsManager.this.getExecutor(), rm));
            if (this.restoreDeferredMode) {
                ICommand<MIInfo> commandDefered = ICudaGdbOptions.createCommand(commandFactory, (IDMContext)ctx, "kernel_events", "none");
                this.control.queueCommand(commandDefered, new DataRequestMonitor((Executor)CudaBreakpointsManager.this.getExecutor(), rm));
            }
        }
    }
}

