/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.state.SourceLocation;

public class CudaRuntimeInformation {
    public static final CudaRuntimeInformation INACTIVE = new CudaRuntimeInformation(-1, -1, -1, -1, CudaThreadState.INACTIVE);
    private CudaThreadState state = CudaThreadState.INACTIVE;
    private short deviceId = (short)-1;
    private short sm = (short)-1;
    private short warpId = (short)-1;
    private short lane = (short)-1;
    private SourceLocation location;
    private short activeWarps = (short)-1;
    private byte activeLanes = (byte)-1;
    private byte divergentLanes = (byte)-1;
    private CudaCoord blockIdx;
    private long kernelId = -1L;
    private CudaCoord threadIdx;

    public CudaRuntimeInformation(short deviceId, short sm, short warpId, short lane, CudaThreadState state) {
        this(deviceId, sm, warpId, lane, state, null);
    }

    public CudaRuntimeInformation(short deviceId, short sm, short warpId, short lane, CudaThreadState state, SourceLocation location) {
        this.deviceId = deviceId;
        this.sm = sm;
        this.warpId = warpId;
        this.lane = lane;
        this.state = state;
        this.location = location;
    }

    public CudaThreadState getState() {
        return this.state;
    }

    public short getDeviceId() {
        return this.deviceId;
    }

    public short getSm() {
        return this.sm;
    }

    public short getWarpId() {
        return this.warpId;
    }

    public short getLane() {
        return this.lane;
    }

    public SourceLocation getSourceLocation() {
        return this.location;
    }

    public short getActiveWarps() {
        return this.activeWarps;
    }

    public void setActiveWarps(short activeWarps) {
        this.activeWarps = activeWarps;
    }

    public byte getActiveLanes() {
        return this.activeLanes;
    }

    public void setActiveLanes(byte activeLane) {
        this.activeLanes = activeLane;
    }

    public byte getDivergentLanes() {
        return this.divergentLanes;
    }

    public void setDivergentLanes(byte divergentLanes) {
        this.divergentLanes = divergentLanes;
    }

    public CudaCoord getBlockIdx() {
        return this.blockIdx;
    }

    public void setBlockIdx(CudaCoord blockIdx) {
        this.blockIdx = blockIdx;
    }

    public long getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(long kernelId) {
        this.kernelId = kernelId;
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.location = sourceLocation;
    }

    public CudaCoord getThreadIdx() {
        return this.threadIdx;
    }

    public void setThreadIdx(CudaCoord threadIdx) {
        this.threadIdx = threadIdx;
    }

    public void setState(CudaThreadState state) {
        this.state = state;
    }
}

