/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

final class CudaObjectsFactory {
    private static final CudaObjectsFactory INSTANCE = new CudaObjectsFactory();

    public static CudaObjectsFactory getInstance() {
        return INSTANCE;
    }

    private CudaObjectsFactory() {
    }

    private void checkSessionState(IDMContext parent) throws CudaException {
        if (!DsfSession.isSessionActive((String)parent.getSessionId())) {
            throw new CudaException("Debugger session was terminated");
        }
    }

    public Block newBlock(Kernel kernel, CudaCoord blockIdx) throws CudaException {
        this.checkSessionState(kernel);
        return new Block(kernel, blockIdx);
    }

    public Lane newLane(Warp warp, short id) throws CudaException {
        this.checkSessionState(warp);
        return new Lane(warp, id);
    }

    public StreamingMultiprocessor newSM(Device device, short id) throws CudaException {
        this.checkSessionState(device);
        return new StreamingMultiprocessor(device, id);
    }

    public DeviceThread newThread(Block block, CudaCoord threadIdx) throws CudaException {
        this.checkSessionState(block);
        return new DeviceThread(block, threadIdx);
    }

    public Warp newWarp(StreamingMultiprocessor sm, short id) throws CudaException {
        this.checkSessionState(sm);
        return new Warp(sm, id);
    }
}

