/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.mi;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.mi.AbstractMITableInfo;
import com.nvidia.cuda.ide.debug.mi.LaunchTraceInfo;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.Kernel;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MICudaInfoLaunchTraceInfo
extends AbstractMITableInfo<LaunchTraceInfo> {
    public MICudaInfoLaunchTraceInfo(MIOutput record) {
        super(record, "InfoCudaLaunchTraceTable");
    }

    @Override
    protected void setEntryProperty(LaunchTraceInfo entry, String var, String val) {
        if ("kernel".equals(var)) {
            entry.setId(Long.parseLong(val.trim()));
        } else if ("device".equals(var)) {
            entry.setDeviceId(Short.parseShort(val.trim()));
        } else if ("status".equals(var)) {
            entry.setStatus(Kernel.KernelState.decode(val));
        } else if ("gridDim".equals(var)) {
            entry.setGridDim(CudaDim.parse(val));
        } else if ("blockDim".equals(var)) {
            entry.setBlockDim(CudaDim.parse(val));
        } else if ("invocation".equals(var)) {
            entry.setName(val);
        } else if (!("grid".equals(var) || "current".equals(var) || "level".equals(var) || "invocation".equals(var))) {
            Activator.log(2, String.format("Unexpected -cuda-info-launch-trace command output field: %s", var), null);
        }
    }

    @Override
    protected LaunchTraceInfo createEntry(String variable) {
        return new LaunchTraceInfo();
    }

    protected LaunchTraceInfo[] createArray(int length) {
        return new LaunchTraceInfo[length];
    }
}

