/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.launch.CudaRunControl;
import com.nvidia.cuda.ide.debug.util.ProgressMonitorDialogWithHideButton;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public final class CudaSuspendHandler
implements ISuspendHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public CudaSuspendHandler(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
    }

    public void canExecute(IEnabledStateRequest request) {
        this.canExecuteSingle(request);
    }

    private void canExecuteSingle(final IEnabledStateRequest request) {
        this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            public void doExecute() {
                this.getRunControl().canSuspend(this.getContext(), (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(){

                    protected void handleCompleted() {
                        request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                        request.done();
                    }
                });
            }
        });
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean execute(IDebugCommandRequest request) {
        this.fExecutor.submit((Runnable)((Object)new SuspendRunnable(this.fExecutor, this.fTracker, request.getElements()[0], request)));
        return false;
    }

    private static final class SuspendRunnable
    extends DsfCommandRunnable {
        private final DsfExecutor fExecutor;

        private SuspendRunnable(DsfExecutor fExecutor, DsfServicesTracker servicesTracker, Object element, IDebugCommandRequest request) {
            super(servicesTracker, element, request);
            this.fExecutor = fExecutor;
        }

        public void doExecute() {
            final CountDownLatch latch = this.showProgressDialog(this.getRunControl(), this.getContext());
            IRunControl runControl = this.getRunControl();
            RequestMonitor rm = new RequestMonitor((Executor)this.fExecutor, null){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleCompleted() {
                    SuspendRunnable.this.progressDone(this.getStatus(), latch);
                    super.handleCompleted();
                }
            };
            if (runControl instanceof CudaRunControl) {
                ((CudaRunControl)runControl).suspendIndefinite(this.getContext(), rm);
            } else {
                runControl.suspend(this.getContext(), rm);
            }
        }

        private void progressDone(IStatus status, CountDownLatch latch) {
            latch.countDown();
        }

        private CountDownLatch showProgressDialog(final IRunControl runControl, final IRunControl.IExecutionDMContext dmc) {
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                final Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        display.timerExec(500, new Runnable(){

                            @Override
                            public void run() {
                                SuspendRunnable.this.startProgressDisplay(latch, runControl, dmc);
                            }
                        });
                    }
                });
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            return latch;
        }

        protected void startProgressDisplay(final CountDownLatch latch, final IRunControl runControl, final IRunControl.IExecutionDMContext dmc) {
            if (latch.getCount() > 0L) {
                try {
                    ProgressMonitorDialogWithHideButton dialog = new ProgressMonitorDialogWithHideButton(SWTUtil.getShell());
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Suspending application", -1);
                            while (!(latch.await(300L, TimeUnit.MILLISECONDS) || runControl.isSuspended(dmc) || monitor.isCanceled())) {
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Activator.log(e);
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
            }
        }
    }
}

