/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.jni.CallTree;
import com.nvidia.viper.jni.CpuSampleInfo;
import com.nvidia.viper.jni.CpuThread;
import java.text.NumberFormat;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;

public class CallTreeLabelProvider
extends DelegatingStyledCellLabelProvider {
    private static final int TRIANGLE_SIZE = 8;
    private static final int MIN_BAR_SIZE = 2;
    private static final int VERTICAL_BAR_WIDTH = 25;
    public static final int VERTICAL_BAR_HEIGHT = 70;
    private static final int SCALE_COLUMN_WIDTH = 80;
    public static final int HORIZONTAL_BAR_WIDTH = 500;
    public static final int HORIZONTAL_MARGIN = 50;
    private columns column;
    private CpuThread thread;
    private static final float[][] HSB_scale_coefficient = new float[][]{{0.0f, 0.96f, 0.99f}, {0.0f, 0.92f, 0.98f}, {0.0f, 0.88f, 0.97f}, {0.01f, 0.85f, 0.96f}, {0.01f, 0.81f, 0.95f}, {0.01f, 0.77f, 0.94f}, {0.01f, 0.74f, 0.93f}, {0.01f, 0.71f, 0.92f}, {0.01f, 0.67f, 0.91f}, {0.02f, 0.64f, 0.9f}, {0.02f, 0.61f, 0.89f}, {0.02f, 0.58f, 0.88f}, {0.02f, 0.55f, 0.87f}, {0.03f, 0.52f, 0.86f}, {0.03f, 0.49f, 0.85f}, {0.03f, 0.46f, 0.84f}, {0.03f, 0.44f, 0.83f}, {0.04f, 0.41f, 0.82f}, {0.04f, 0.38f, 0.81f}, {0.04f, 0.36f, 0.8f}, {0.04f, 0.34f, 0.79f}, {0.05f, 0.31f, 0.78f}, {0.05f, 0.29f, 0.77f}, {0.06f, 0.27f, 0.76f}, {0.06f, 0.25f, 0.75f}, {0.06f, 0.23f, 0.74f}, {0.07f, 0.21f, 0.73f}, {0.07f, 0.19f, 0.72f}, {0.08f, 0.18f, 0.71f}, {0.08f, 0.16f, 0.7f}, {0.09f, 0.14f, 0.69f}, {0.1f, 0.13f, 0.68f}, {0.1f, 0.12f, 0.67f}, {0.11f, 0.1f, 0.66f}, {0.12f, 0.09f, 0.65f}, {0.13f, 0.08f, 0.64f}, {0.13f, 0.07f, 0.63f}, {0.14f, 0.06f, 0.62f}, {0.15f, 0.05f, 0.61f}, {0.17f, 0.04f, 0.6f}, {0.18f, 0.03f, 0.59f}, {0.19f, 0.03f, 0.58f}, {0.21f, 0.02f, 0.57f}, {0.23f, 0.01f, 0.56f}, {0.25f, 0.01f, 0.55f}, {0.27f, 0.01f, 0.54f}, {0.3f, 0.0f, 0.53f}, {0.33f, 0.0f, 0.52f}, {0.37f, 0.0f, 0.51f}, {0.42f, 0.0f, 0.5f}, {0.6f, 0.0f, 0.49f}, {0.64f, 0.0f, 0.48f}, {0.67f, 0.0f, 0.47f}, {0.7f, 0.01f, 0.46f}, {0.73f, 0.01f, 0.45f}, {0.75f, 0.01f, 0.44f}, {0.77f, 0.02f, 0.43f}, {0.79f, 0.03f, 0.42f}, {0.8f, 0.03f, 0.41f}, {0.82f, 0.04f, 0.4f}, {0.83f, 0.05f, 0.39f}, {0.84f, 0.06f, 0.38f}, {0.85f, 0.07f, 0.37f}, {0.86f, 0.08f, 0.36f}, {0.87f, 0.09f, 0.35f}, {0.88f, 0.1f, 0.34f}, {0.89f, 0.12f, 0.33f}, {0.9f, 0.13f, 0.32f}, {0.9f, 0.14f, 0.31f}, {0.91f, 0.16f, 0.3f}, {0.91f, 0.18f, 0.29f}, {0.92f, 0.19f, 0.28f}, {0.93f, 0.21f, 0.27f}, {0.93f, 0.23f, 0.26f}, {0.94f, 0.25f, 0.25f}, {0.94f, 0.27f, 0.24f}, {0.94f, 0.29f, 0.23f}, {0.95f, 0.31f, 0.22f}, {0.95f, 0.34f, 0.21f}, {0.95f, 0.36f, 0.2f}, {0.96f, 0.38f, 0.19f}, {0.96f, 0.41f, 0.18f}, {0.96f, 0.44f, 0.17f}, {0.97f, 0.46f, 0.16f}, {0.97f, 0.49f, 0.15f}, {0.97f, 0.52f, 0.14f}, {0.97f, 0.55f, 0.13f}, {0.98f, 0.58f, 0.12f}, {0.98f, 0.61f, 0.11f}, {0.98f, 0.64f, 0.1f}, {0.98f, 0.67f, 0.09f}, {0.99f, 0.71f, 0.08f}, {0.99f, 0.74f, 0.07f}, {0.99f, 0.77f, 0.06f}, {0.99f, 0.81f, 0.05f}, {0.99f, 0.85f, 0.04f}, {1.0f, 0.88f, 0.03f}, {1.0f, 0.92f, 0.02f}, {1.0f, 0.96f, 0.01f}, {1.0f, 1.0f, 0.0f}};
    private static final RGB MAX_SCALE_COLOR = new RGB(255.0f, 0.395f, 0.59f);
    private static final RGB MIN_SCALE_COLOR = new RGB(24.0f, 0.08f, 0.925f);
    private static final Color EMPTY_CELL_COLOR = new Color(null, 242, 242, 242);
    private static final Color BAR_HIGHLIGHT_COLOR = new Color(null, 244, 140, 68);
    private static final Color BAR_EMPHASIS_COLOR = new Color(null, 0, 0, 0);
    private static final Color BAR_LIGHT_COLOR = new Color(null, 234, 234, 234);
    private highlighting highlight = highlighting.BAR;
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private static TimeFormatter numberFormatterLong = new TimeFormatter();
    private boolean columnSelected;

    static {
        percentFormatter.setMaximumFractionDigits(3);
        percentFormatter.setGroupingUsed(false);
    }

    public CallTreeLabelProvider(columns ci) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CallTreeStyledProvider());
        this.column = ci;
    }

    public CallTreeLabelProvider(CpuThread t) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CallTreeStyledProvider());
        this.column = columns.THREAD;
        this.thread = t;
    }

    public Color getBackground(Object element) {
        if (element instanceof CallTree) {
            CallTree node = (CallTree)element;
            if (this.column == columns.THREAD && node.getHits(this.thread) == 0) {
                return EMPTY_CELL_COLOR;
            }
        }
        return super.getBackground(element);
    }

    protected void measure(Event event, Object element) {
        if (this.highlight == highlighting.BAR) {
            event.height = 70;
        }
        super.measure(event, element);
    }

    private void drawVerticalBar(GC gc, Point cursor, Point bounding_box, Color color, int value, int height) {
        gc.setBackground(color);
        int yvalue = Math.min(bounding_box.y - value, bounding_box.y - 2);
        int vertical_height = height == 0 ? 70 - yvalue : height;
        gc.fillRectangle(cursor.x, cursor.y + yvalue, bounding_box.x, vertical_height);
    }

    private void drawHorizontalBar(GC gc, Point cursor, Point bounding_box, Color color, int beginning_value, int ending_value) {
        gc.setBackground(color);
        gc.fillRectangle(cursor.x + beginning_value, cursor.y, ending_value - beginning_value, bounding_box.y);
    }

    private void drawTriangleAnnotation(GC gc, Point cursor, Point bounding_box, Color color, Point value, int displacement, int offset) {
        gc.setBackground(color);
        int topOfBar = cursor.y + bounding_box.y - value.y;
        gc.fillPolygon(new int[]{cursor.x + value.x, topOfBar - displacement + offset, cursor.x + 4 + value.x, topOfBar + offset, cursor.x - 4 + value.x, topOfBar + offset});
    }

    private void drawMaxAnnotation(GC gc, Point cursor, Point bounding_box, Color color, Point value) {
        this.drawVerticalBar(gc, cursor, bounding_box, color, value.y, 2);
        cursor.x += 6;
        int offset = 14;
        this.drawTriangleAnnotation(gc, cursor, bounding_box, color, value, 8, offset);
    }

    private void drawMinAnnotation(GC gc, Point cursor, Point bounding_box, Color color, Point value) {
        this.drawVerticalBar(gc, cursor, bounding_box, color, value.y, 2);
        cursor.x += 6;
        int offset = -14;
        this.drawTriangleAnnotation(gc, cursor, bounding_box, color, value, -8, offset);
    }

    public static void drawText(GC gc, Point cursor, Color color, Point value, String text, int style) {
        gc.setForeground(color);
        Point textSize = gc.textExtent(text);
        int x = (style & 0x4000) > 0 ? cursor.x - textSize.x + value.x : ((style & 0x1000000) > 0 ? cursor.x - textSize.x / 2 + value.x : cursor.x + value.x);
        int y = (style & 0x80) > 0 ? cursor.y - textSize.y + value.y : ((style & 0x400) > 0 ? cursor.y + value.y : cursor.y - textSize.y / 2 + value.y);
        gc.drawText(text, x, y, true);
    }

    public static void paintScale(PaintEvent event) {
        int i = 0;
        while (i < 100) {
            event.gc.setBackground(CallTreeLabelProvider.getScaleColor(i));
            event.gc.fillRectangle(event.x + 2 * i, event.y, 2, event.height);
            ++i;
        }
        String maxText = "max";
        String minText = "0";
        CallTreeLabelProvider.drawText(event.gc, new Point(event.x + 1, event.y + event.height / 2), new Color(null, 0, 0, 0), new Point(0, 0), minText, 131072);
        CallTreeLabelProvider.drawText(event.gc, new Point(event.x + event.width - 1, event.y + event.height / 2), new Color(null, 0, 0, 0), new Point(0, 0), maxText, 16384);
    }

    protected void paint(Event event, Object element) {
        if (element instanceof CallTree) {
            CallTree node = (CallTree)element;
            Color outlierColor = BAR_EMPHASIS_COLOR;
            Color meanColor = BAR_LIGHT_COLOR;
            Color scaleColor = new Color(null, 160, 160, 160);
            Color textColor = new Color(null, 0, 0, 0);
            Color highlightColor = BAR_HIGHLIGHT_COLOR;
            int maxValue = node.getHits(CallTree.getMaxThread());
            int minValue = node.getHits(CallTree.getMinThread());
            int meanValue = node.getHits(CallTree.getAvgThread());
            int absoluteMaxValue = node.getMaxValue();
            String maxText = CallTreeLabelProvider.shortFormatNumber(node, node.getHits(CallTree.getMaxThread())).getString();
            String minText = CallTreeLabelProvider.shortFormatNumber(node, node.getHits(CallTree.getMinThread())).getString();
            Point vcell = new Point(25, event.height);
            Point hcell = new Point(500, event.height);
            Point cursor = new Point(event.x, event.y);
            switch (this.column) {
                case RANGE: {
                    int threadValue;
                    int min = 50 + minValue * 500 / absoluteMaxValue;
                    int max = 50 + maxValue * 500 / absoluteMaxValue;
                    if (min == max) {
                        --min;
                        ++max;
                    }
                    int percentage = (int)(100.0f * ((float)maxValue / (float)absoluteMaxValue)) - 1;
                    Color rangeColor = CallTreeLabelProvider.getScaleColor(percentage);
                    this.drawHorizontalBar(event.gc, cursor, hcell, meanColor, 50, min);
                    this.drawHorizontalBar(event.gc, cursor, hcell, rangeColor, min, max);
                    CallTreeLabelProvider.drawText(event.gc, new Point(event.x - 2, event.y + event.height / 2), textColor, new Point(min, 0), minText, 16384);
                    CallTreeLabelProvider.drawText(event.gc, new Point(event.x + 2, event.y + event.height / 2), textColor, new Point(max, 0), maxText, 131072);
                    int mean = 50 + meanValue * 500 / absoluteMaxValue;
                    if (Math.min(max - mean, mean - min) >= 10) {
                        this.drawTriangleAnnotation(event.gc, cursor, hcell, meanColor, new Point(mean, event.height / 2), 8, 0);
                        this.drawTriangleAnnotation(event.gc, cursor, hcell, meanColor, new Point(mean, event.height / 2), -8, 0);
                    }
                    if (node.getCpuSampleData().getSelectedThread() == null || (threadValue = node.getHits(node.getCpuSampleData().getSelectedThread())) == 0) break;
                    int thread = 50 + threadValue * 500 / absoluteMaxValue;
                    this.drawHorizontalBar(event.gc, cursor, hcell, highlightColor, thread - 1, thread + 1);
                    break;
                }
                case HITS: {
                    int threadMaxValue = node.getThreadMaxValue();
                    int percentageValue = (int)((double)node.getHits() / (double)threadMaxValue * 100.0) - 1;
                    Color percentageColor = CallTreeLabelProvider.getScaleColor(percentageValue);
                    int length = node.getHits() * 500 / threadMaxValue;
                    this.drawHorizontalBar(event.gc, cursor, hcell, percentageColor, 0, length);
                    break;
                }
                case THREAD: {
                    if (node.getHits(this.thread) == 0) break;
                    int value = maxValue == minValue ? event.height - 4 : (int)((double)(node.getHits(this.thread) - minValue) * (double)(event.height - 4) / (double)(maxValue - minValue));
                    int hits = node.getHits(this.thread);
                    int percentage = (int)(100.0 * (double)hits / (double)absoluteMaxValue - 1.0);
                    Color threadColor = this.isThreadSelected() ? BAR_HIGHLIGHT_COLOR : CallTreeLabelProvider.getScaleColor(percentage);
                    this.drawVerticalBar(event.gc, cursor, vcell, threadColor, value, 0);
                    if (node.isMaxThread(this.thread) && !node.isMinThread(this.thread)) {
                        this.drawMaxAnnotation(event.gc, cursor, vcell, outlierColor, new Point(0, value));
                    }
                    if (!node.isMinThread(this.thread) || node.isMaxThread(this.thread)) break;
                    this.drawMinAnnotation(event.gc, cursor, vcell, outlierColor, new Point(0, value));
                    break;
                }
                case V_SCALE: {
                    cursor = new Point(event.x + 80 - 25, event.y);
                    this.drawVerticalBar(event.gc, cursor, vcell, scaleColor, 0, 2);
                    CallTreeLabelProvider.drawText(event.gc, cursor, textColor, new Point(0, 0), maxText, 17408);
                    this.drawVerticalBar(event.gc, cursor, vcell, scaleColor, event.height - 4, 2);
                    CallTreeLabelProvider.drawText(event.gc, cursor, textColor, new Point(0, event.height), minText, 16512);
                    break;
                }
            }
        }
        super.paint(event, element);
    }

    public static Color getScaleColor(int percentage) {
        Color threadColor;
        if (percentage >= 0 && percentage < 100) {
            float[] maxHSB = MAX_SCALE_COLOR.getHSB();
            float[] minHSB = MIN_SCALE_COLOR.getHSB();
            float hue = HSB_scale_coefficient[percentage][0] * (maxHSB[0] - minHSB[0]) + minHSB[0];
            float saturation = HSB_scale_coefficient[percentage][1] * (float)percentage / 100.0f * (maxHSB[1] - minHSB[1]) + minHSB[1];
            float brightness = HSB_scale_coefficient[percentage][2] * (minHSB[2] - maxHSB[2]) + maxHSB[2];
            RGB rgb_color = new RGB(hue, saturation, brightness);
            threadColor = new Color(null, rgb_color.red, rgb_color.green, rgb_color.blue);
        } else {
            threadColor = new Color(null, CallTreeLabelProvider.MIN_SCALE_COLOR.red, CallTreeLabelProvider.MIN_SCALE_COLOR.green, CallTreeLabelProvider.MIN_SCALE_COLOR.blue);
        }
        return threadColor;
    }

    private boolean isThreadSelected() {
        return this.columnSelected;
    }

    protected StyledString getStyledText(Object element) {
        CallTree node;
        CpuSampleInfo samples;
        if (element instanceof CallTree && (samples = (node = (CallTree)element).getCpuSampleData()) != null) {
            switch (this.column) {
                case HITS: 
                case TOTAL: {
                    return CallTreeLabelProvider.shortFormatNumber(node, node.getHits());
                }
                case AVG: {
                    return CallTreeLabelProvider.shortFormatNumber(node, node.getHits(CallTree.getAvgThread()));
                }
                case MAX: {
                    return CallTreeLabelProvider.shortFormatNumber(node, node.getHits(CallTree.getMaxThread()));
                }
                case MIN: {
                    return CallTreeLabelProvider.shortFormatNumber(node, node.getHits(CallTree.getMinThread()));
                }
                case THREAD: {
                    return new StyledString("");
                }
                case EVENT_NAME: {
                    return new StyledString(node.getDisplayName());
                }
                case LIBRARY_NAME: {
                    return new StyledString(node.getLibName());
                }
                case PERCENTAGE: {
                    return new StyledString(percentFormatter.format(node.getTimePercentage(samples)));
                }
            }
        }
        return super.getStyledText(element);
    }

    public String getTitle() {
        switch (this.column) {
            case HITS: {
                return "Time";
            }
            case TOTAL: {
                return "Total";
            }
            case EVENT_NAME: {
                return "Event";
            }
            case LIBRARY_NAME: {
                return "Library";
            }
            case PERCENTAGE: {
                return "%";
            }
            case AVG: {
                return "Avg";
            }
            case MAX: {
                return "Max";
            }
            case MIN: {
                return "Min";
            }
            case RANGE: {
                return "Range";
            }
            case V_SCALE: {
                return "";
            }
            case THREAD: {
                return Integer.toString(this.thread.getOrdinal());
            }
        }
        return "";
    }

    public String getToolTipText(Object element) {
        String hText = "";
        StyledString number = new StyledString("");
        String toolTip = new String();
        if (element instanceof CallTree) {
            CallTree node = (CallTree)element;
            number = this.thread == null || node.getHits(this.thread) == 0 ? new StyledString("-") : new StyledString(numberFormatterLong.format((double)node.getHits(this.thread) * node.getSamplingPeriod(node.getCpuSampleData()) * 1000.0, true));
            if (this.thread != null && node.isMaxThread(this.thread) && !node.isMinThread(this.thread)) {
                hText = "\n(Maximum)";
            } else if (this.thread != null && node.isMinThread(this.thread) && !node.isMaxThread(this.thread)) {
                hText = "\n(Minumum)";
            }
            if (node != null && this.column == columns.THREAD) {
                toolTip = "Function: " + node.getDisplayName() + "\n" + this.thread.getTitle() + ": " + number + hText;
            } else if (node != null && this.column == columns.RANGE) {
                toolTip = "Function: " + node.getDisplayName() + "\n" + "Minumum: " + this.format_number(node, CallTree.getMinThread()) + "\n" + "Mean: " + this.format_number(node, CallTree.getAvgThread()) + "\n" + "Maximum: " + this.format_number(node, CallTree.getMaxThread());
            } else if (node != null && this.column == columns.PERCENTAGE) {
                toolTip = "Function: " + node.getDisplayName() + "\n" + "Mean across all threads: " + this.format_number(node, CallTree.getAvgThread()) + "\n" + "Total across all threads: " + this.format_number(node, CallTree.getTotalThread()) + "\n";
                toolTip = node.getCurrentThread() == CallTree.getTotalThread() ? String.valueOf(toolTip) + "Total as a percentage of all the time spent on all threads: " + this.getStyledText(node) : String.valueOf(toolTip) + "Percentage of all the time spent on " + node.getCurrentThread().getTitle() + ": " + this.getStyledText(node);
            }
        }
        return toolTip;
    }

    private StyledString format_number(CallTree node, CpuThread thread) {
        return new StyledString(numberFormatterLong.format((double)node.getHits(thread) * node.getSamplingPeriod(node.getCpuSampleData()) * 1000.0, true));
    }

    private static StyledString shortFormatNumber(CallTree node, int hits) {
        CpuSampleInfo samples = node.getCpuSampleData();
        TimeFormatter shortTime = new TimeFormatter();
        shortTime.setFractionDigits(1);
        if (samples != null) {
            return new StyledString(shortTime.format((double)hits * node.getSamplingPeriod(samples) * 1000.0, true));
        }
        return new StyledString("");
    }

    public void selectColumn() {
        this.columnSelected = true;
    }

    public void deselectColumn() {
        this.columnSelected = false;
    }

    public CpuThread getThread() {
        return this.thread;
    }

    public static class CallTreeStyledProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public StyledString getStyledText(Object element) {
            return new StyledString();
        }
    }

    public static enum columns {
        HITS,
        PERCENTAGE,
        EVENT_NAME,
        LIBRARY_NAME,
        MAX,
        MIN,
        AVG,
        TOTAL,
        THREAD,
        RANGE,
        V_SCALE;

    }

    private static enum highlighting {
        NONE,
        BACKGROUND,
        BAR;

    }
}

