/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.output.MIVarEvaluateExpressionInfo;

public class Value
extends CObject
implements ICDIValue {
    protected Variable fVariable;
    protected boolean fIsReference;

    public Value(Variable v) {
        super((Target)v.getTarget());
        this.fVariable = v;
    }

    protected Variable getVariable() throws CDIException {
        return this.fVariable;
    }

    public String getTypeName() throws CDIException {
        return this.getVariable().getTypeName();
    }

    public String getValueString() throws CDIException {
        if (!this.getVariable().isUpdated()) {
            this.getVariable().update();
        }
        String result = "";
        MISession mi = ((Target)this.getTarget()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarEvaluateExpression var = factory.createMIVarEvaluateExpression(this.getVariable().getMIVar().getVarName());
        try {
            int index;
            mi.postCommand(var);
            MIVarEvaluateExpressionInfo info = var.getMIVarEvaluateExpressionInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            result = info.getValue();
            if (this.fIsReference && result.startsWith("@0x") && (index = result.indexOf(58)) > 0 && index + 1 < result.length()) {
                result = result.substring(index + 1).trim();
            }
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
        return result;
    }

    public int getChildrenNumber() throws CDIException {
        return this.getVariable().getMIVar().getNumChild();
    }

    public boolean hasChildren() throws CDIException {
        return this.getChildrenNumber() > 0;
    }

    public ICDIVariable[] getVariables() throws CDIException {
        return this.getVariable().getChildren();
    }

    public ICDIType getType() throws CDIException {
        return this.getVariable().getType();
    }

    public void setIsReference(boolean isReference) {
        this.fIsReference = isReference;
    }
}

