/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointHit;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.EndSteppingRange;
import org.eclipse.cdt.debug.mi.core.cdi.ErrorInfo;
import org.eclipse.cdt.debug.mi.core.cdi.EventBreakpointHit;
import org.eclipse.cdt.debug.mi.core.cdi.FunctionFinished;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryEvent;
import org.eclipse.cdt.debug.mi.core.cdi.SignalReceived;
import org.eclipse.cdt.debug.mi.core.cdi.WatchpointScope;
import org.eclipse.cdt.debug.mi.core.cdi.WatchpointTrigger;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.EventBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointHitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIErrorEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointScopeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointTriggerEvent;
import org.eclipse.cdt.gdb.internal.eventbkpts.GdbCatchpoints;

public class SuspendedEvent
implements ICDISuspendedEvent {
    MIEvent event;
    Session session;

    public SuspendedEvent(Session s, MIEvent e) {
        this.session = s;
        this.event = e;
    }

    public ICDISessionObject getReason() {
        if (this.event instanceof MIBreakpointHitEvent) {
            BreakpointManager bkptMgr = this.session.getBreakpointManager();
            Breakpoint bkpt = bkptMgr.getBreakpoint(this.event.getMISession(), ((MIBreakpointHitEvent)this.event).getNumber());
            if (bkpt instanceof EventBreakpoint) {
                return new EventBreakpointHit(this.session, GdbCatchpoints.eventToGdbCatchpointKeyword((String)((EventBreakpoint)bkpt).getEventType()));
            }
            return new BreakpointHit(this.session, (MIBreakpointHitEvent)this.event);
        }
        if (this.event instanceof MIWatchpointTriggerEvent) {
            return new WatchpointTrigger(this.session, (MIWatchpointTriggerEvent)this.event);
        }
        if (this.event instanceof MIWatchpointScopeEvent) {
            return new WatchpointScope(this.session, (MIWatchpointScopeEvent)this.event);
        }
        if (this.event instanceof MISteppingRangeEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MISignalEvent) {
            return new SignalReceived(this.session, (MISignalEvent)this.event);
        }
        if (this.event instanceof MILocationReachedEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MIFunctionFinishedEvent) {
            return new FunctionFinished(this.session, (MIFunctionFinishedEvent)this.event);
        }
        if (this.event instanceof MIErrorEvent) {
            return new ErrorInfo(this.session, (MIErrorEvent)this.event);
        }
        if (this.event instanceof MISharedLibEvent) {
            return new SharedLibraryEvent(this.session);
        }
        return this.session;
    }

    public ICDIObject getSource() {
        Target target = this.session.getTarget(this.event.getMISession());
        return target;
    }
}

