/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;
import org.eclipse.rse.ui.wizards.ISystemWizardPage;
import org.eclipse.rse.ui.wizards.RSEDialogPageMessageLine;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractSystemWizardPage
extends WizardPage
implements ISystemWizardPage,
ISystemMessageLine {
    private Object input;
    private ISystemMessageLine msgLine;
    private String helpId;
    private Composite parentComposite;
    private SystemMessage pendingMessage;
    private SystemMessage pendingErrorMessage;

    public AbstractSystemWizardPage(IWizard wizard, String pageName, String pageTitle, String pageDescription) {
        super(pageName);
        this.setWizard(wizard);
        if (pageTitle != null) {
            this.setTitle(pageTitle);
        } else if (wizard instanceof AbstractSystemWizard) {
            this.setTitle(((AbstractSystemWizard)wizard).getWizardPageTitle());
        }
        this.setDescription(pageDescription);
    }

    public AbstractSystemWizardPage(IWizard wizard, String pageName, String pageDescription) {
        this(wizard, pageName, null, pageDescription);
    }

    public void setHelp(String helpId) {
        if (this.parentComposite != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, helpId);
        }
        this.helpId = helpId;
    }

    public void setInputObject(Object inputObject) {
        this.input = inputObject;
    }

    public Object getInputObject() {
        return this.input;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public ISystemMessageLine getMessageLine() {
        return this;
    }

    public abstract Control createContents(Composite var1);

    protected abstract Control getInitialFocusControl();

    public abstract boolean performFinish();

    public void dispose() {
        super.dispose();
        this.msgLine = null;
        this.input = null;
        this.parentComposite = null;
        this.pendingMessage = null;
        this.pendingErrorMessage = null;
    }

    public void createControl(Composite parent) {
        Composite myComposite = new Composite(parent, 0);
        myComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(32, 2, true, true);
        myComposite.setLayoutData((Object)gd);
        this.parentComposite = myComposite;
        Control c = this.createContents(myComposite);
        if (c instanceof Composite) {
            this.applyMnemonics((Composite)c);
            this.parentComposite = (Composite)c;
            if (this.helpId != null) {
                SystemWidgetHelpers.setHelp((Control)this.parentComposite, this.helpId);
            }
        } else if (c instanceof Button) {
            Mnemonics ms = new Mnemonics();
            ms.setMnemonic((Button)c);
        }
        this.msgLine = new RSEDialogPageMessageLine((DialogPage)this);
        if (this.pendingMessage != null) {
            this.setMessage(this.pendingMessage);
        }
        if (this.pendingErrorMessage != null) {
            this.setErrorMessage(this.pendingErrorMessage);
        }
        this.setControl((Control)myComposite);
    }

    protected void applyMnemonics(Composite c) {
        SystemWidgetHelpers.setWizardPageMnemonics(c);
    }

    public void setVisible(boolean visible) {
        Control c;
        super.setVisible(visible);
        if (visible && (c = this.getInitialFocusControl()) != null) {
            c.setFocus();
        }
    }

    public void clearErrorMessage() {
        if (this.msgLine != null && this.getControl() != null && !this.getControl().isDisposed()) {
            this.msgLine.clearErrorMessage();
        }
    }

    public void clearMessage() {
        if (this.msgLine != null && this.getControl() != null && !this.getControl().isDisposed()) {
            this.msgLine.clearMessage();
        }
    }

    public SystemMessage getSystemErrorMessage() {
        if (this.msgLine != null) {
            return this.msgLine.getSystemErrorMessage();
        }
        return null;
    }

    public void setErrorMessage(SystemMessage message) {
        if (this.msgLine != null) {
            if (message != null) {
                this.msgLine.setErrorMessage(message);
            } else {
                this.msgLine.clearErrorMessage();
            }
        } else {
            this.pendingErrorMessage = message;
        }
    }

    public void setErrorMessage(Throwable exc) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(exc);
        } else {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEF8002");
            msg.makeSubstitution((Object)exc);
            this.pendingErrorMessage = msg;
        }
    }

    public void setMessage(SystemMessage message) {
        if (this.msgLine != null) {
            this.msgLine.setMessage(message);
        } else {
            this.pendingMessage = message;
        }
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    protected void addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
    }

    protected void addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
    }

    protected void addGrowableFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        filler.setLayoutData((Object)data);
    }

    protected void setFocus(Control control) {
        if (this != this.getContainer().getCurrentPage()) {
            this.getContainer().showPage((IWizardPage)this);
        }
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }
}

