/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.VMViewerUpdateTracing;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesUpdateStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class VMPropertiesUpdate
extends VMViewerUpdate
implements IPropertiesUpdate {
    private final Set<String> fProperties;
    private boolean fCreatedOwnMap = false;
    private Map<String, Object> fValues = Collections.emptyMap();

    public VMPropertiesUpdate(Set<String> properties, IViewerUpdate parentUpdate, DataRequestMonitor<Map<String, Object>> rm) {
        super(parentUpdate, (RequestMonitor)rm);
        super.setStatus((IStatus)new PropertiesUpdateStatus());
        this.fProperties = properties;
    }

    public VMPropertiesUpdate(Set<String> properties, TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, DataRequestMonitor<Map<String, Object>> rm) {
        super(elementPath, viewerInput, presentationContext, (RequestMonitor)rm);
        super.setStatus((IStatus)new PropertiesUpdateStatus());
        this.fProperties = properties;
    }

    @Override
    public Set<String> getProperties() {
        return this.fProperties;
    }

    public Map<String, Object> getValues() {
        return this.fValues;
    }

    @Override
    public synchronized void setProperty(String property, Object value) {
        if (!this.fCreatedOwnMap) {
            this.fCreatedOwnMap = true;
            Map<String, Object> curValues = this.fValues;
            this.fValues = new HashMap<String, Object>(this.fProperties.size() * 4 / 3, 0.75f);
            if (curValues != null) {
                this.fValues.putAll(curValues);
            }
        }
        this.fValues.put(property, value);
    }

    @Override
    public synchronized void setAllProperties(Map<String, Object> properties) {
        if (this.fCreatedOwnMap) {
            this.fValues.putAll(properties);
        } else {
            this.fValues = properties;
        }
    }

    @Override
    public void setStatus(IStatus status) {
        if (status instanceof PropertiesUpdateStatus) {
            super.setStatus(status);
        } else if (this.getStatus() instanceof PropertiesUpdateStatus) {
            ((PropertiesUpdateStatus)this.getStatus()).add(status);
        } else assert (this.getStatus().getSeverity() == 8) : "VMPropertiesUpdate status should always be a PropertiesUpdateStatus unless update is canceled.";
    }

    @Override
    public void done() {
        DataRequestMonitor rm = (DataRequestMonitor)this.getRequestMonitor();
        rm.setData(this.fValues);
        if (VMViewerUpdateTracing.DEBUG_VMUPDATES && !this.isCanceled() && VMViewerUpdateTracing.matchesFilterRegex(this.getClass())) {
            StringBuilder str = new StringBuilder();
            str.append(String.valueOf(DsfPlugin.getDebugTime()) + " " + LoggingUtils.toString((Object)this) + " marked done; element = " + LoggingUtils.toString((Object)this.getElement()));
            if (this.fValues != null) {
                for (String prop : this.fValues.keySet()) {
                    Object val = this.fValues.get(prop);
                    if (val instanceof String[]) {
                        val = LoggingUtils.toString((String[])((String[])val));
                    }
                    str.append("   " + prop + "=" + val + "\n");
                }
                str.deleteCharAt(str.length() - 1);
            }
            DsfUIPlugin.debug(str.toString());
        }
        super.done();
    }

    public String toString() {
        return "VMPropertiesUpdate:" + this.getElement() + " " + this.fProperties;
    }
}

