/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisResultKernelMemory;
import com.nvidia.viper.ui.analysis.DataGridCanvas;
import com.nvidia.viper.ui.analysis.KernelMemoryDataGrid;
import com.nvidia.viper.ui.analysis.MemoryDataTablePainter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class KernelMemoryDataControl
extends Composite {
    private final List<AnalysisResultKernelMemory.MemoryUnit> memoryUnits;
    private final Map<AnalysisResultKernelMemory.MemoryUnit, DataGridCanvas> memoryUnitTables;

    public KernelMemoryDataControl(List<AnalysisResultKernelMemory.MemoryUnit> memoryUnits, String sysmemLabel, Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GC gc = new GC((Drawable)this);
        int charWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        this.memoryUnitTables = new HashMap<AnalysisResultKernelMemory.MemoryUnit, DataGridCanvas>();
        this.memoryUnits = new ArrayList<AnalysisResultKernelMemory.MemoryUnit>(memoryUnits);
        DataGridCanvas header = this.setupTable(charWidth, true);
        for (AnalysisResultKernelMemory.MemoryUnit mu : this.memoryUnits) {
            DataGridCanvas table = this.createDataTable(parent, mu.getMemoryTableName(), AnalysisResultKernelMemory.MemoryUnit.SYSMEM.equals((Object)mu) ? sysmemLabel : null, charWidth);
            this.memoryUnitTables.put(mu, table);
        }
        header.setHeader(true);
        header.addRow(null, "Transactions", "Bandwidth", "Utilization");
        this.layout();
    }

    public void setInput(AnalysisResultKernelMemory result) {
        for (AnalysisResultKernelMemory.MemoryUnit mu : this.memoryUnits) {
            DataGridCanvas table = this.memoryUnitTables.get((Object)mu);
            if (table == null) continue;
            switch (mu) {
                case L1SHARED: {
                    KernelMemoryDataGrid.fillL1SharedMemoryTable(table.getDataGrid(), result);
                    break;
                }
                case SHARED: {
                    KernelMemoryDataGrid.fillSharedMemoryTable(table.getDataGrid(), result);
                    break;
                }
                case UNIFIED: {
                    KernelMemoryDataGrid.fillUnifiedCacheTable(table.getDataGrid(), result);
                    break;
                }
                case TEX: {
                    KernelMemoryDataGrid.fillTexCacheTable(table.getDataGrid(), result);
                    break;
                }
                case L2: {
                    KernelMemoryDataGrid.fillL2CacheTable(table.getDataGrid(), result);
                    break;
                }
                case DRAM: {
                    KernelMemoryDataGrid.fillDramTable(table.getDataGrid(), result);
                    break;
                }
                case SYSMEM: {
                    KernelMemoryDataGrid.fillSystemMemoryTable(table.getDataGrid(), result);
                    break;
                }
                default: {
                    ViperExceptionHandler.logError("unexpected MemoryUnit: " + (Object)((Object)mu));
                }
            }
        }
        this.layout();
    }

    private DataGridCanvas createDataTable(Composite parent, String label, String secondaryLabel, int charWidth) {
        CLabel lblNewLabel = new CLabel((Composite)this, 0);
        lblNewLabel.setBackground(parent.getBackground());
        lblNewLabel.setText(label);
        if (secondaryLabel != null) {
            Label lblNewSec = new Label((Composite)this, 0);
            lblNewSec.setBackground(parent.getBackground());
            lblNewSec.setText(secondaryLabel);
        }
        return this.setupTable(charWidth, false);
    }

    private DataGridCanvas setupTable(int charWidth, boolean isHeader) {
        DataGridCanvas table = new DataGridCanvas(this, 2048, new MemoryDataTablePainter());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        table.setLayoutData(gd);
        table.addColumn(charWidth * 30, 16384);
        table.addColumn(charWidth * 16, isHeader ? 0x1000000 : 131072);
        table.addColumn(charWidth * 16, isHeader ? 0x1000000 : 131072);
        return table;
    }
}

