/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.run;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ProfileResultManager;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperJob;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.actions.ResetAnalysisAction;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.MetricAggregate;
import com.nvidia.viper.model.MetricPerInstance;
import com.nvidia.viper.model.ProfileMultiProcessBase;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.model.SourceLevelResult;
import com.nvidia.viper.properties.ExpertPropertyDialog;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.PlatformUI;

public class ProfileRunner
extends Runner {
    private final Expert expert;
    private final String progressMessage;
    private final boolean showSettingsDialog;
    private final boolean checkForGlobalEventsAndMetrics;
    private final IDevicesData devicesData;
    private int settingDialogCode;
    private static final String APP_REPLAY_NVPROF_ARGS = "--replay-mode application";

    public ProfileRunner(Session session, Expert expert, IDevicesData devicesData, String progressMessage, boolean showSettingsDialog, boolean checkForGlobalEventsAndMetrics) {
        super(session);
        this.devicesData = devicesData;
        this.showSettingsDialog = showSettingsDialog;
        this.checkForGlobalEventsAndMetrics = checkForGlobalEventsAndMetrics;
        this.expert = expert != null ? expert : session.getExpert();
        this.progressMessage = progressMessage;
    }

    @Override
    public boolean runWithJob() {
        this.settingDialogCode = 1024;
        if (!ProfileRunner.checkRunnable(this.session, true)) {
            return false;
        }
        String[] deviceTypes = this.devicesData.getDeviceTypes();
        if (this.session != null && this.session.isProfileInRebel()) {
            ViperMessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.No_Expert_Title, "Profiling (metrics and events) is not supported on devices with compute capability greater than 7.2");
            return false;
        }
        if (this.showSettingsDialog || this.checkForGlobalEventsAndMetrics && !this.checkExpert(deviceTypes, this.expert)) {
            this.settingDialogCode = new ExpertPropertyDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.session, this.devicesData).open();
            if (this.settingDialogCode != 1024) {
                return false;
            }
        }
        if (this.needProfilingDataDelete(this.session)) {
            new ResetAnalysisAction(this.session, true).run();
            return false;
        }
        if (this.checkForGlobalEventsAndMetrics && !this.checkExpert(deviceTypes, this.expert)) {
            ViperMessageDialog.openInformation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.No_Expert_Title, ViperMessages.No_Expert_Message);
            return false;
        }
        if (!this.lockSession(this.session, true)) {
            return false;
        }
        this.showConsole();
        if (!Activator.getDefault().getViperWorkbench().readyToRun(this.session)) {
            this.unlockSession(this.session);
            return false;
        }
        try {
            ProfileResultManager profileResultManager = new ProfileResultManager();
            String[] stringArray = deviceTypes;
            int n = deviceTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String deviceType = stringArray[n2];
                Map<ITimelineInterval, Set<IProfilingData>> data = this.expert.getAllEnabledEventsMetrics(deviceType);
                if (!data.isEmpty()) {
                    profileResultManager.add(deviceType, data, this.session);
                }
                ++n2;
            }
            this.job = new ExpertJob(profileResultManager);
            this.job.schedule();
        }
        catch (Exception e) {
            ViperException ex = !(e instanceof ViperException) ? new ViperException(e) : (ViperException)e;
            if (!(ex.getMessage().endsWith("LoadPdmCancel") || ex.getMessage().endsWith("PDM_EMPTY") && this.session.getExecutable().isProfileCPU())) {
                ViperExceptionHandler.handle(ViperMessages.Launch_Fail_Title, ViperMessages.Launch_Fail_Message, ex);
            }
            this.unlockSession(this.session);
        }
        return true;
    }

    public int getSettingDialogCode() {
        return this.settingDialogCode;
    }

    @Override
    public IStatus runWithMonitor(IProgressMonitor monitor) {
        return new Status(4, "NYI", "NYI");
    }

    protected boolean checkExpert(String[] deviceTypes, Expert expert) {
        if (expert == null) {
            return false;
        }
        String[] stringArray = deviceTypes;
        int n = deviceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String deviceType = stringArray[n2];
            Set<IProfilingData> enabled = expert.getEnabledEventsMetrics(deviceType, null);
            for (IProfilingData data : enabled) {
                if (!(data instanceof Event) && !(data instanceof MetricAggregate) && !(data instanceof MetricPerInstance)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected String getNvprofBaseArgs(Executable exec) {
        String nvprofArgs = super.getNvprofBaseArgs(exec);
        if (exec.isApplicationReplay()) {
            nvprofArgs = String.valueOf(nvprofArgs) + " --replay-mode application ";
        }
        if (exec.isProfileCPU()) {
            nvprofArgs = String.valueOf(nvprofArgs) + " --cpu-profiling on ";
            if (exec.getPgExplainFile() != null && !exec.getPgExplainFile().isEmpty()) {
                nvprofArgs = String.valueOf(nvprofArgs) + " --cpu-profiling-explain-ccff \"" + exec.getPgExplainFile() + "\" ";
            }
        }
        return nvprofArgs;
    }

    protected String getNvprofEventMetricOptionName(IProfilingData.Kind kind) {
        switch (kind) {
            case event: {
                return " --aggregate-mode on --events ";
            }
            case aggregate_metric: {
                return " --aggregate-mode on --metrics ";
            }
            case instance_metric: {
                return " --aggregate-mode off --metrics ";
            }
            case sourcelevel: {
                return " --dump-instruction-correlation --source-level-analysis ";
            }
            case sourcelevel_pc_sampling: {
                int period = this.session.getPCSamplingPeriod();
                String samplingPeriodArgs = period != 0 ? "--pc-sampling-period " + this.session.getPCSamplingPeriod() : "";
                return " --dump-instruction-correlation " + samplingPeriodArgs + " --source-level-analysis ";
            }
            case continuous_mode_instance_metric: {
                return " --event-collection-mode continuous --aggregate-mode off --metrics ";
            }
        }
        throw new IllegalArgumentException(kind.name());
    }

    static /* synthetic */ String access$0(ProfileRunner profileRunner) {
        return profileRunner.progressMessage;
    }

    private class ExpertJob
    extends ViperJob {
        private ProfileResultManager profileResultManager;

        public ExpertJob(ProfileResultManager profileResultManager) {
            super("Collect Profile Data");
            this.profileResultManager = profileResultManager;
        }

        protected String getNvprofEventMetricsArgs(IDevicesData deviceData, SessionFilter scope, List<ProfileResultManager.SinglePassProfileData> passProfileData) throws ViperException {
            String args = scope == null ? "" : scope.getNvprofCommandLine();
            try {
                for (ProfileResultManager.SinglePassProfileData profileData : passProfileData) {
                    Object object;
                    String deviceType = profileData.getDeviceType();
                    int[] devices = deviceData.getDeviceIds(deviceType);
                    if (devices != null && devices.length > 0) {
                        boolean first = true;
                        args = String.valueOf(args) + " --devices";
                        object = devices;
                        int n = devices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object device = object[n2];
                            args = String.valueOf(args) + (first ? " " : ",") + (int)device;
                            first = false;
                            ++n2;
                        }
                    }
                    Set<IProfilingData> eventsMetrics = profileData.getEventsMetrics();
                    boolean[] hasData = new boolean[IProfilingData.Kind.values().length];
                    StringBuilder[] typeArgs = new StringBuilder[hasData.length];
                    int i = 0;
                    while (i < IProfilingData.Kind.values().length) {
                        hasData[i] = false;
                        typeArgs[i] = new StringBuilder(ProfileRunner.this.getNvprofEventMetricOptionName(IProfilingData.Kind.values()[i]));
                        ++i;
                    }
                    object = eventsMetrics.iterator();
                    while (object.hasNext()) {
                        IProfilingData data = (IProfilingData)object.next();
                        int typeCode = data.getProfileDataKind().ordinal();
                        if (hasData[typeCode]) {
                            typeArgs[typeCode].append(",");
                        }
                        typeArgs[typeCode].append(data.getName());
                        hasData[typeCode] = true;
                    }
                    i = 0;
                    while (i < typeArgs.length) {
                        if (hasData[i]) {
                            args = String.valueOf(args) + typeArgs[i];
                        }
                        ++i;
                    }
                }
            }
            catch (RuntimeException e) {
                throw new ViperException("unable to create profile configuration for launch", e);
            }
            return args;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void runNext(IProgressMonitor monitor, final int pass, final int totalPasses) throws CoreException, ViperException, OperationCanceledException, DeviceListNotReadyException {
            File[] files;
            List<ProfileResultManager.SinglePassProfileData> passProfileData = this.profileResultManager.getPassProfileData(pass);
            if (passProfileData == null || passProfileData.isEmpty()) {
                return;
            }
            Executable exec = ProfileRunner.this.session.getExecutable();
            SessionFilter scope = this.profileResultManager.getPassScope(pass);
            String nvprofArgs = ProfileRunner.this.getNvprofBaseArgs(exec);
            if ((nvprofArgs = String.valueOf(nvprofArgs) + this.getNvprofEventMetricsArgs(FileSystem.getFilesystem(exec.getConnectionName()).getDeviceData(false), scope, passProfileData)).contains(ProfileRunner.this.getNvprofEventMetricOptionName(IProfilingData.Kind.continuous_mode_instance_metric))) {
                nvprofArgs = nvprofArgs.replaceAll(ProfileMultiProcessBase.PROFILE_CHILD_PROCESSES, "");
                nvprofArgs = nvprofArgs.replaceAll(ProfileRunner.APP_REPLAY_NVPROF_ARGS, "");
            }
            if (nvprofArgs.contains(SourceLevelResult.PC_SAMPLING.getName())) {
                nvprofArgs = nvprofArgs.replaceAll(ProfileMultiProcessBase.PROFILE_CHILD_PROCESSES, "");
            }
            SubProgressMonitor launchProgress = new SubProgressMonitor(monitor, -1){

                public void beginTask(String name, int totalWork) {
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                    if (totalPasses > 1) {
                        super.subTask("Running application... (" + (pass + 1) + " of " + totalPasses + ")");
                    } else {
                        super.subTask("Running application...");
                    }
                }
            };
            if (System.getenv("VIPER_DEBUG") != null || ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
                System.out.println("nvprof: " + nvprofArgs);
            }
            if ((files = FileSystem.getFilesystem(exec.getConnectionName()).runNvprof(exec, nvprofArgs, String.valueOf(ProfileRunner.this.getOutputFileName(exec)) + pass, (IProgressMonitor)launchProgress)) == null || launchProgress.isCanceled()) {
                monitor.setCanceled(true);
                if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
                    System.out.println("nvprof: command was canceled");
                }
                return;
            }
            if (files.length > 0) {
                File profileFile = files[0];
                if (profileFile.exists()) {
                    if (profileFile.isFile()) {
                        this.profileResultManager.setPassProfileFile(pass, profileFile);
                    } else if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
                        System.out.println("nvprof output file is not a file: File=" + profileFile);
                    }
                } else if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
                    System.out.println("nvprof output file does not exist: File=" + profileFile);
                }
            }
        }
    }
}

