/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.model.CriticalPathStat;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CriticalPath {
    private boolean otherCpuActivitiesAdded = false;
    public CriticalPathStat[] stats;
    public long pdmHandle = -1L;
    public long totalDuration = -1L;
    public long totalCudaEventsTime = -1L;
    public long[] activityIds;
    private Set<ITimelineInterval> intervalsOnCriticalPath = null;

    public long getTotalCudaEventsTime() {
        if (this.totalCudaEventsTime != -1L) {
            return this.totalCudaEventsTime;
        }
        this.totalCudaEventsTime = 0L;
        if (this.stats != null) {
            int i = 0;
            while (i < this.stats.length) {
                this.totalCudaEventsTime += this.stats[i].time;
                ++i;
            }
        }
        return this.totalCudaEventsTime;
    }

    public void addOtherCpuActivities() {
        if (!this.otherCpuActivitiesAdded && this.totalDuration > 0L) {
            CriticalPathStat stat = new CriticalPathStat("<Other>", this.totalDuration - this.getTotalCudaEventsTime(), 0L);
            if (this.stats != null) {
                CriticalPathStat[] newFunction = Arrays.copyOf(this.stats, this.stats.length + 1);
                newFunction[this.stats.length] = stat;
                this.stats = newFunction;
            }
            this.otherCpuActivitiesAdded = true;
        }
    }

    public Set<ITimelineInterval> getIntervalsOnCriticalPath(Session session) {
        if (this.intervalsOnCriticalPath == null) {
            HashSet<ITimelineInterval> intervals = new HashSet<ITimelineInterval>();
            long[] lArray = this.activityIds;
            int n = this.activityIds.length;
            int n2 = 0;
            while (n2 < n) {
                long activityId = lArray[n2];
                ITimelineInterval interval = session.loadInterval(activityId, false);
                intervals.add(interval);
                ++n2;
            }
            this.intervalsOnCriticalPath = intervals;
        }
        return this.intervalsOnCriticalPath;
    }
}

