/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.wizards;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.wizards.IContextPropertyListener;
import com.nvidia.common.wizards.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;

public final class ContextPropertyStore
implements IContextPropertyListener {
    private ContextPropertyStore defaults;
    private final Collection<IContextPropertyListener> listeners = new ConcurrentLinkedQueue<IContextPropertyListener>();
    private final Map<PropertyDescriptor<?>, ContextPropertyObservable<?>> observables = new HashMap();
    private final Map<PropertyDescriptor<?>, Object> properties = new HashMap();
    private final Realm realm;

    public ContextPropertyStore(Realm realm) {
        this.realm = realm;
    }

    public void addSessionPropertyListener(IContextPropertyListener listener) {
        this.listeners.add(listener);
    }

    private synchronized void fireSessionPropertyChanged(PropertyDescriptor<?> property, Object oldValue, Object newValue) {
        for (IContextPropertyListener listener : this.listeners) {
            listener.propertyChanged(property, oldValue, newValue);
        }
    }

    public <K> K getProperty(PropertyDescriptor<K> name) {
        if (this.realm.isCurrent()) {
            return name.clazz.cast(this.observeProperty(name).getValue());
        }
        return this.innerGetProperty(name);
    }

    public Realm getRealm() {
        return this.realm;
    }

    private <K> K innerGetProperty(PropertyDescriptor<K> name) {
        if (this.properties.containsKey(name)) {
            return name.clazz.cast(this.properties.get(name));
        }
        if (this.defaults != null) {
            return this.defaults.getProperty(name);
        }
        return null;
    }

    public <K> void innerSetProperty(PropertyDescriptor<K> name, K value) {
        K old = this.getProperty(name);
        if (!CoreUtil.equals(old, value)) {
            if (name.isCleared(value)) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
            this.notifyPropertyChange(name, value, old);
        }
    }

    public boolean isClean() {
        return this.properties.isEmpty();
    }

    public synchronized ContextPropertyStore newDefaultsStore() {
        if (this.defaults == null) {
            this.defaults = new ContextPropertyStore(this.realm);
            this.defaults.addSessionPropertyListener(this);
            return this.defaults;
        }
        return this.defaults.newDefaultsStore();
    }

    private void notifyPropertyChange(PropertyDescriptor<?> name, final Object value, final Object old) {
        final ContextPropertyObservable<?> observable = this.observables.get(name);
        if (observable != null) {
            final ValueDiff diff = new ValueDiff(){

                public Object getNewValue() {
                    return value;
                }

                public Object getOldValue() {
                    return old;
                }
            };
            Realm r = observable.getRealm();
            if (r.isCurrent()) {
                observable.fireValueChange(diff);
            } else {
                r.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        observable.fireValueChange(diff);
                    }
                });
            }
        }
        this.fireSessionPropertyChanged(name, old, value);
    }

    public synchronized <K> IObservableValue observeProperty(PropertyDescriptor<K> name) {
        ContextPropertyObservable<Object> value = this.observables.get(name);
        if (value == null) {
            value = new ContextPropertyObservable<K>(this.realm, name);
            this.observables.put(name, value);
        }
        return value;
    }

    @Override
    public void propertyChanged(PropertyDescriptor<?> property, Object oldValue, Object newValue) {
        if (!this.properties.containsKey(property)) {
            this.notifyPropertyChange(property, oldValue, newValue);
        }
    }

    public void removeSessionPropertyListener(IContextPropertyListener listener) {
        this.listeners.remove(listener);
    }

    public <K> void setProperty(PropertyDescriptor<K> name, K value) {
        this.observeProperty(name).setValue(value);
    }

    private final class ContextPropertyObservable<K>
    extends AbstractObservableValue {
        private final PropertyDescriptor<K> property;

        public ContextPropertyObservable(Realm realm, PropertyDescriptor<K> property) {
            super(realm);
            this.property = property;
        }

        protected Object doGetValue() {
            return ContextPropertyStore.this.innerGetProperty(this.property);
        }

        protected void doSetValue(Object value) {
            ContextPropertyStore.this.innerSetProperty(this.property, this.property.clazz.cast(value));
        }

        public void fireStale() {
            super.fireStale();
        }

        protected void fireValueChange(ValueDiff diff) {
            super.fireValueChange(diff);
        }

        public Object getValueType() {
            return this.property.clazz;
        }

        public String toString() {
            return String.format("{Observing %s}", this.property);
        }
    }
}

