/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterValuesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIDataListRegisterValues
extends MICommand<MIDataListRegisterValuesInfo> {
    int[] regnums;
    int fFmt;

    public MIDataListRegisterValues(IStack.IFrameDMContext ctx, int fmt) {
        this(ctx, fmt, null);
    }

    public MIDataListRegisterValues(IStack.IFrameDMContext ctx, int fmt, int[] regnos) {
        super((IDMContext)ctx, "-data-list-register-values");
        this.init(fmt, regnos);
    }

    @Deprecated
    public MIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt) {
        this(ctx, fmt, null);
    }

    @Deprecated
    public MIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt, int[] regnos) {
        super((IDMContext)ctx, "-data-list-register-values");
        this.init(fmt, regnos);
    }

    private void init(int fmt, int[] regnos) {
        this.regnums = regnos;
        String format = "x";
        switch (fmt) {
            case 5: {
                format = "N";
                break;
            }
            case 4: {
                format = "r";
                break;
            }
            case 3: {
                format = "d";
                break;
            }
            case 2: {
                format = "t";
                break;
            }
            case 1: {
                format = "o";
                break;
            }
            case 0: {
                format = "x";
                break;
            }
            default: {
                format = "x";
            }
        }
        this.fFmt = fmt;
        this.setOptions(new String[]{format});
        if (regnos != null && regnos.length > 0) {
            String[] array = new String[regnos.length];
            int i = 0;
            while (i < regnos.length) {
                array[i] = Integer.toString(regnos[i]);
                ++i;
            }
            this.setParameters(array);
        }
    }

    public int[] getRegList() {
        return this.regnums;
    }

    @Override
    public MIDataListRegisterValuesInfo getResult(MIOutput output) {
        return new MIDataListRegisterValuesInfo(output);
    }

    public MIDataListRegisterValues coalesceWith(ICommand<? extends ICommandResult> command) {
        if (!(command instanceof MIDataListRegisterValues)) {
            return null;
        }
        IDMContext context = this.getContext();
        if (!command.getContext().equals(context)) {
            return null;
        }
        MIDataListRegisterValues cmd = (MIDataListRegisterValues)command;
        if (this.fFmt != cmd.fFmt) {
            return null;
        }
        int[] newregnos = new int[this.regnums.length + cmd.regnums.length];
        int idx = 0;
        while (idx < this.regnums.length) {
            newregnos[idx] = this.regnums[idx];
            ++idx;
        }
        int curloc = this.regnums.length;
        int ndx = 0;
        while (ndx < cmd.regnums.length) {
            int curnum = cmd.regnums[ndx];
            int ldx = 0;
            while (ldx < this.regnums.length) {
                if (newregnos[ldx] == curnum) break;
                ++ldx;
            }
            if (ldx == this.regnums.length) {
                newregnos[curloc] = curnum;
                ++curloc;
            }
            ++ndx;
        }
        int[] finalregnums = new int[curloc];
        int fdx = 0;
        while (fdx < curloc) {
            finalregnums[fdx] = newregnos[fdx];
            ++fdx;
        }
        MIDataListRegisterValues dataValues = context instanceof IStack.IFrameDMContext ? new MIDataListRegisterValues((IStack.IFrameDMContext)context, this.fFmt, finalregnums) : new MIDataListRegisterValues((IMIExecutionDMContext)context, this.fFmt, finalregnums);
        return dataValues;
    }
}

