/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.telnet.terminal;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.net.io.ToNetASCIIInputStream;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.internal.services.telnet.ITelnetSessionProvider;
import org.eclipse.rse.internal.services.telnet.terminal.EOFDetectingInputStreamWrapper;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.services.terminals.AbstractTerminalShell;

public class TelnetTerminalShell
extends AbstractTerminalShell {
    private ITelnetSessionProvider fSessionProvider;
    private TelnetClient fTelnetClient;
    private String fEncoding;
    private EOFDetectingInputStreamWrapper fInputStream;
    private OutputStream fOutputStream;
    private Writer fOutputStreamWriter;
    private int fWidth = 0;
    private int fHeight = 0;
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();

    public TelnetTerminalShell(ITelnetSessionProvider sessionProvider, String ptyType, String encoding, String[] environment, String initialWorkingDirectory, String commandToRun) throws SystemMessageException {
        try {
            try {
                this.fSessionProvider = sessionProvider;
                boolean onUNIX = System.getProperty("os.name").toLowerCase().startsWith("unix") || System.getProperty("os.name").toLowerCase().startsWith("linux");
                this.fEncoding = encoding;
                if (ptyType == null) {
                    this.fTelnetClient = new TelnetClient();
                } else {
                    this.fTelnetClient = new TelnetClient(ptyType);
                    this.fTelnetClient.addOptionHandler((TelnetOptionHandler)new TerminalTypeOptionHandler(ptyType, true, true, true, true));
                }
                this.fTelnetClient.addOptionHandler((TelnetOptionHandler)new EchoOptionHandler(false, true, true, true));
                this.fTelnetClient.addOptionHandler((TelnetOptionHandler)new SuppressGAOptionHandler(true, true, true, true));
                this.fTelnetClient.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(this.fWidth, this.fHeight, true, true, true, true));
                this.fTelnetClient = this.fSessionProvider.loginTelnetClient(this.fTelnetClient, (IProgressMonitor)new NullProgressMonitor());
                this.fOutputStream = this.fTelnetClient.getOutputStream();
                this.fInputStream = onUNIX ? new EOFDetectingInputStreamWrapper((InputStream)new ToNetASCIIInputStream(this.fTelnetClient.getInputStream())) : new EOFDetectingInputStreamWrapper(this.fTelnetClient.getInputStream());
                this.fOutputStreamWriter = this.fEncoding != null ? new BufferedWriter(new OutputStreamWriter(this.fOutputStream, encoding)) : new BufferedWriter(new OutputStreamWriter(this.fOutputStream));
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix((String)initialWorkingDirectory));
                }
                if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                throw new RemoteFileException("Error creating Terminal", e);
            }
        }
        finally {
            this.isActive();
        }
    }

    public String getDefaultEncoding() {
        return this.fEncoding;
    }

    protected String recode(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return s;
        }
        if (encoding.equals(defaultEncoding)) {
            return s;
        }
        byte[] bytes = s.getBytes(encoding);
        return new String(bytes, defaultEncoding);
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public void writeToShell(String command) throws IOException {
        if (this.isActive()) {
            command = "#break".equals(command) ? "\u0003" : String.valueOf(command) + "\r\n";
            this.fOutputStreamWriter.write(command);
            this.fOutputStreamWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (this.fTelnetClient != null) {
            try {
                try {
                    this.getInputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    this.getOutputStream().close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                try {
                    TelnetClient ioe = this.fTelnetClient;
                    synchronized (ioe) {
                        if (this.fTelnetClient.isConnected()) {
                            this.fTelnetClient.disconnect();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.fTelnetClient = null;
                this.isActive();
            }
        }
    }

    public boolean isActive() {
        if (this.fTelnetClient != null && this.fTelnetClient.isConnected() && !this.isDisconnected()) {
            return true;
        }
        this.exit();
        return false;
    }

    private boolean isDisconnected() {
        return this.fInputStream.isEOF();
    }

    public boolean isLocalEcho() {
        return this.fTelnetClient.getLocalOptionState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fTelnetClient != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            TelnetClient telnetClient = this.fTelnetClient;
            synchronized (telnetClient) {
                try {
                    this.fTelnetClient.deleteOptionHandler(31);
                    this.fTelnetClient.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(newWidth, newHeight, true, true, true, true));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }
}

