/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import javax.olap.cursor.RowDataNavigation;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;

public class SharedCubeResultSetEvaluator
extends BIRTCubeResultSetEvaluator {
    protected int fCategoryInnerLevelIndex;
    protected int fYOptionalInnerLevelIndex;
    protected CursorPositionNode fMainPositionNodes;
    protected CursorPositionNode fSubPositionNodes;
    protected boolean fIsColEdgeAsCategoryCursor;

    public SharedCubeResultSetEvaluator(ICubeResultSet rs, Chart cm) {
        super(rs);
        this.init(rs.getCubeQuery(), cm);
    }

    protected void init(IBaseCubeQueryDefinition queryDefinition, Chart cm) {
        this.parseLevelIndex(queryDefinition, cm);
        try {
            this.initCubeCursor();
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
    }

    public SharedCubeResultSetEvaluator(ICubeQueryResults qr, IBaseCubeQueryDefinition queryDefinition, Chart cm) throws BirtException {
        super((ICubeResultSet)null);
        this.qr = qr;
        this.init(queryDefinition, cm);
    }

    protected void parseLevelIndex(IBaseCubeQueryDefinition queryDefintion, Chart cm) {
        this.fCategoryInnerLevelIndex = -1;
        this.fYOptionalInnerLevelIndex = -1;
        if (queryDefintion instanceof ICubeQueryDefinition) {
            String[] categoryExprs = ChartUtil.getCategoryExpressions((Chart)cm);
            ICubeQueryDefinition cqd = (ICubeQueryDefinition)queryDefintion;
            IEdgeDefinition rowED = cqd.getEdge(1);
            IEdgeDefinition colED = cqd.getEdge(2);
            HashMap<String, String> cubeBindingMap = new HashMap<String, String>();
            List bindingList = cqd.getBindings();
            int i = 0;
            while (i < bindingList.size()) {
                Binding b = (Binding)bindingList.get(i);
                if (b.getExpression() instanceof IScriptExpression) {
                    cubeBindingMap.put(b.getBindingName(), ((IScriptExpression)b.getExpression()).getText());
                }
                ++i;
            }
            if (categoryExprs != null && categoryExprs.length > 0) {
                if (rowED != null) {
                    this.fCategoryInnerLevelIndex = this.findInnerLevelIndex(categoryExprs[0], rowED, cubeBindingMap);
                }
                if (this.fCategoryInnerLevelIndex < 0 && colED != null) {
                    this.fCategoryInnerLevelIndex = this.findInnerLevelIndex(categoryExprs[0], colED, cubeBindingMap);
                    this.fIsColEdgeAsCategoryCursor = true;
                }
            }
            if (this.fCategoryInnerLevelIndex < 0) {
                return;
            }
            String[] yOptionalExprs = ChartUtil.getYOptoinalExpressions((Chart)cm);
            if (yOptionalExprs != null && yOptionalExprs.length > 0) {
                if (this.fIsColEdgeAsCategoryCursor && rowED != null) {
                    this.fYOptionalInnerLevelIndex = this.findInnerLevelIndex(yOptionalExprs[0], rowED, cubeBindingMap);
                } else if (colED != null) {
                    this.fYOptionalInnerLevelIndex = this.findInnerLevelIndex(yOptionalExprs[0], colED, cubeBindingMap);
                }
            }
        }
    }

    protected int findInnerLevelIndex(String expr, IEdgeDefinition edge, Map<String, String> cubeBindingMap) {
        int index = -1;
        if (ChartUtil.isEmpty((String)expr)) {
            return index;
        }
        Map<String, List<String>> dimLevelMaps = this.getDimLevelsNames(edge);
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        Collection bindingNames = exprCodec.getBindingNames(expr);
        for (String bindName : bindingNames) {
            String cubeBindingExpr = cubeBindingMap.get(bindName);
            if (cubeBindingExpr == null) continue;
            String[] lNames = exprCodec.getLevelNames(cubeBindingExpr);
            for (Map.Entry<String, List<String>> dimLevels : dimLevelMaps.entrySet()) {
                if (!lNames[0].equals(dimLevels.getKey())) continue;
                List<String> levelNames = dimLevels.getValue();
                int i = 1;
                while (i < lNames.length) {
                    int levelIndex = levelNames.indexOf(lNames[i]);
                    if (levelIndex > index) {
                        index = levelIndex;
                    }
                    ++i;
                }
            }
        }
        return index;
    }

    protected Map<String, List<String>> getDimLevelsNames(IEdgeDefinition ed) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        List dimensions = ed.getDimensions();
        for (IDimensionDefinition d : dimensions) {
            ArrayList<String> levelNames = new ArrayList<String>();
            map.put(d.getName(), levelNames);
            List hieDefs = d.getHierarchy();
            for (IHierarchyDefinition hd : hieDefs) {
                List levels = hd.getLevels();
                for (ILevelDefinition ld : levels) {
                    levelNames.add(ld.getName());
                }
            }
        }
        return map;
    }

    @Override
    protected void initCubeCursor() throws OLAPException, BirtException {
        List dimCursors;
        if (this.cubeCursor == null) {
            this.cubeCursor = this.getCubeCursor();
            List edges = this.cubeCursor.getOrdinateEdge();
            if (edges.size() == 0) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, Messages.getString("exception.no.cube.edge"));
            }
            if (edges.size() == 1) {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                this.subEdgeCursor = null;
            } else {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                this.subEdgeCursor = (EdgeCursor)edges.get(1);
            }
        }
        if (this.fCategoryInnerLevelIndex >= 0 && this.fYOptionalInnerLevelIndex < 0 && this.subEdgeCursor != null) {
            if (!this.fIsColEdgeAsCategoryCursor) {
                this.mainEdgeCursor = this.subEdgeCursor;
            }
            this.subEdgeCursor = null;
        } else if (this.fCategoryInnerLevelIndex >= 0 && this.fYOptionalInnerLevelIndex >= 0 && this.fIsColEdgeAsCategoryCursor) {
            EdgeCursor tmp = this.mainEdgeCursor;
            this.mainEdgeCursor = this.subEdgeCursor;
            this.subEdgeCursor = tmp;
        }
        if (this.subEdgeCursor == null) {
            dimCursors = this.mainEdgeCursor.getDimensionCursor();
            if (this.fCategoryInnerLevelIndex >= 0) {
                this.fMainPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fCategoryInnerLevelIndex);
            } else if (this.fYOptionalInnerLevelIndex >= 0) {
                this.fMainPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fYOptionalInnerLevelIndex);
            }
        } else {
            if (this.fCategoryInnerLevelIndex >= 0) {
                dimCursors = this.subEdgeCursor.getDimensionCursor();
                this.fSubPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fCategoryInnerLevelIndex);
            }
            if (this.fYOptionalInnerLevelIndex >= 0) {
                dimCursors = this.mainEdgeCursor.getDimensionCursor();
                this.fMainPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fYOptionalInnerLevelIndex);
            }
        }
    }

    @Override
    protected ICubeCursor getCubeCursor() throws BirtException {
        if (this.rs != null) {
            return (ICubeCursor)this.rs.getCubeCursor();
        }
        return this.qr.getCubeCursor();
    }

    protected CursorPositionNode initCursorPositionsNodes(List dimCursorList, int innerLevelIndex) {
        CursorPositionNode pn = null;
        CursorPositionNode rootPN = null;
        int i = innerLevelIndex;
        while (i >= 0) {
            if (pn == null) {
                rootPN = pn = new CursorPositionNode((RowDataNavigation)dimCursorList.get(i));
            } else {
                pn.setParentNode(new CursorPositionNode((RowDataNavigation)dimCursorList.get(i)));
                pn = pn.getParentNode();
            }
            --i;
        }
        return rootPN;
    }

    @Override
    public boolean next() {
        block9: {
            boolean hasNext;
            block10: {
                ++this.iIndex;
                if (this.subEdgeCursor == null) break block9;
                hasNext = false;
                while (hasNext = this.hasNext(this.subEdgeCursor)) {
                    if (this.fSubPositionNodes.positionIsChanged()) break;
                }
                this.fSubPositionNodes.updatePosition();
                if (!hasNext) break block10;
                return true;
            }
            this.lstBreaks.add(this.iIndex);
            this.subEdgeCursor.first();
            this.fSubPositionNodes.updatePosition();
            hasNext = false;
            while (hasNext = this.hasNext(this.mainEdgeCursor)) {
                if (this.fMainPositionNodes.positionIsChanged()) break;
            }
            this.fMainPositionNodes.updatePosition();
            if (hasNext) {
                return true;
            }
        }
        try {
            boolean hasNext = false;
            while (hasNext = this.hasNext(this.mainEdgeCursor)) {
                if (this.fMainPositionNodes.positionIsChanged()) break;
            }
            this.fMainPositionNodes.updatePosition();
            if (hasNext) {
                return true;
            }
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    @Override
    public boolean first() {
        try {
            if (this.mainEdgeCursor.first()) {
                this.fMainPositionNodes.updatePosition();
                if (this.subEdgeCursor != null) {
                    this.subEdgeCursor.first();
                    this.fSubPositionNodes.updatePosition();
                } else {
                    this.bWithoutSub = true;
                }
                return true;
            }
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    static class CursorPositionNode {
        private RowDataNavigation fCursor;
        private CursorPositionNode fParentNode;
        private long fPosition = -1L;

        public CursorPositionNode getParentNode() {
            return this.fParentNode;
        }

        void setParentNode(CursorPositionNode parentNode) {
            this.fParentNode = parentNode;
        }

        CursorPositionNode(RowDataNavigation cursor) {
            this.fCursor = cursor;
        }

        long getPosition() {
            return this.fPosition;
        }

        void updatePosition() throws OLAPException {
            this.fPosition = this.fCursor.getPosition();
            if (this.fParentNode != null) {
                this.fParentNode.updatePosition();
            }
        }

        boolean positionIsChanged() throws OLAPException {
            if (this.fPosition != this.fCursor.getPosition()) {
                return true;
            }
            if (this.fCursor.getPosition() == 0L && this.fParentNode != null) {
                return this.fParentNode.positionIsChanged();
            }
            return false;
        }
    }
}

