/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.sdk.ui;

import com.nvidia.common.ui.Messages;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.devices.CudaDevice;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class PreemptionFieldEditor
extends FieldEditor {
    private Button checkbox;
    private Group group;

    private static GridData createLayoutData(int numColumns) {
        GridData data = new GridData(4, -1, true, false, numColumns, 1);
        data.widthHint = 400;
        return data;
    }

    private static Label createMainLabel(Composite panel) {
        Label label = new Label(panel, 64);
        label.setLayoutData((Object)new GridData(768));
        label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        return label;
    }

    private static boolean hasSM35() {
        if (CudaDevice.devicesFilteredExternally()) {
            return true;
        }
        Object[] devices = CudaDevice.getDevices(null);
        if (CoreUtil.isNullOrEmpty((Object[])devices)) {
            return true;
        }
        Object[] objectArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Object cudaDevice = objectArray[n2];
            if (cudaDevice.getVersionMajor() > 3 || cudaDevice.getVersionMajor() == 3 && cudaDevice.getVersionMinor() >= 5) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PreemptionFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        this.group.setLayoutData((Object)PreemptionFieldEditor.createLayoutData(numColumns));
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.group = new Group(parent, 0);
        this.group.setText(this.getLabelText());
        this.group.setLayout((Layout)new GridLayout(1, false));
        this.group.setLayoutData((Object)PreemptionFieldEditor.createLayoutData(numColumns));
        if (PreemptionFieldEditor.hasSM35()) {
            CLabel warning = new CLabel((Composite)this.group, 0);
            warning.setLayoutData((Object)new GridData(768));
            warning.setText(Messages.warning_preeption_is_beta);
            warning.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            Label label = PreemptionFieldEditor.createMainLabel((Composite)this.group);
            label.setText(Messages.message_preemption_is_awesome);
            this.checkbox = new Button((Composite)this.group, 32);
            this.checkbox.setText(Messages.checkbox_preemption);
            this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreemptionFieldEditor.this.fireValueChanged("field_editor_value", !PreemptionFieldEditor.this.checkbox.getSelection(), PreemptionFieldEditor.this.checkbox.getSelection());
                }
            });
        } else {
            Label label = PreemptionFieldEditor.createMainLabel((Composite)this.group);
            label.setText(Messages.warning_preemption_requires35);
        }
    }

    protected void doLoad() {
        if (this.checkbox != null) {
            boolean b = this.getPreferenceStore().getBoolean(this.getPreferenceName());
            this.checkbox.setSelection(b && PreemptionFieldEditor.hasSM35());
        }
    }

    protected void doLoadDefault() {
        if (this.checkbox != null) {
            boolean b = this.getPreferenceStore().getDefaultBoolean(this.getPreferenceName());
            this.checkbox.setSelection(b && PreemptionFieldEditor.hasSM35());
        }
    }

    protected void doStore() {
        if (this.checkbox != null && this.checkbox.getSelection()) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), true);
        } else {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        }
    }

    public int getNumberOfControls() {
        return 1;
    }
}

