/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.rewrite.IScribe;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.MacroExpansionHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ExpressionWriter
extends NodeWriter {
    private static final String VECTORED_DELETE_OP = "[] ";
    private static final String DELETE = "delete ";
    private static final String STATIC_CAST_OP = "static_cast<";
    private static final String REINTERPRET_CAST_OP = "reinterpret_cast<";
    private static final String DYNAMIC_CAST_OP = "dynamic_cast<";
    private static final String CONST_CAST_OP = "const_cast<";
    private static final String CLOSING_CAST_BRACKET_OP = ">";
    private static final String ARROW = "->";
    private static final String SPACE_QUESTIONMARK_SPACE = " ? ";
    private static final String NEW = "new ";
    private static final String CLOSING_BRACKET_OP = ")";
    private static final String TYPEOF_OP = "typeof (";
    private static final String ALIGNOF_OP = "alignof (";
    private static final String TYPEID_OP = "typeid (";
    private static final String OPEN_BRACKET_OP = "(";
    private static final String SIZEOF_OP = "sizeof ";
    private static final String SIZEOF_PARAMETER_PACK_OP = "sizeof... ";
    private static final String NOT_OP = "!";
    private static final String TILDE_OP = "~";
    private static final String AMPERSAND_OP = "&";
    private static final String STAR_OP = "*";
    private static final String UNARY_MINUS_OP = "-";
    private static final String UNARY_PLUS_OP = "+";
    private static final String INCREMENT_OP = "++";
    private static final String DECREMENT_OP = "--";
    private static final String MIN_OP = " <? ";
    private static final String MAX_OP = " >? ";
    private static final String PMARROW_OP = "->*";
    private static final String PMDOT_OP = ".*";
    private static final String ELLIPSES = " ... ";
    private static final String NOT_EQUALS_OP = " != ";
    private static final String EQUALS_OP = " == ";
    private static final String BINARY_OR_ASSIGN = " |= ";
    private static final String BINARY_XOR_ASSIGN_OP = " ^= ";
    private static final String BINARY_AND_ASSIGN_OP = " &= ";
    private static final String SHIFT_RIGHT_ASSIGN_OP = " >>= ";
    private static final String SHIFT_LEFT_ASSIGN_OP = " <<= ";
    private static final String MINUS_ASSIGN_OP = " -= ";
    private static final String PLUS_ASSIGN_OP = " += ";
    private static final String MODULO_ASSIGN_OP = " %= ";
    private static final String DIVIDE_ASSIGN_OP = " /= ";
    private static final String MULTIPLY_ASSIGN_OP = " *= ";
    private static final String LOGICAL_OR_OP = " || ";
    private static final String LOGICAL_AND_OP = " && ";
    private static final String BINARY_OR_OP = " | ";
    private static final String BINARY_XOR_OP = " ^ ";
    private static final String BINARY_AND_OP = " & ";
    private static final String GREAER_EQUAL_OP = " >= ";
    private static final String LESS_EQUAL_OP = " <= ";
    private static final String GREATER_THAN_OP = " > ";
    private static final String LESS_THAN_OP = " < ";
    private static final String SHIFT_RIGHT_OP = " >> ";
    private static final String SHIFT_LEFT_OP = " << ";
    private static final String MINUS_OP = " - ";
    private static final String PLUS_OP = " + ";
    private static final String MODULO_OP = " % ";
    private static final String DIVIDE_OP = " / ";
    private static final String MULTIPLY_OP = " * ";
    private static final String THIS = "this";
    private static final String THROW = "throw ";
    private final MacroExpansionHandler macroHandler;

    public ExpressionWriter(IScribe scribe, ASTWriterVisitor visitor, MacroExpansionHandler macroHandler, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
        this.macroHandler = macroHandler;
    }

    public void writeExpression(IASTExpression expression) {
        if (expression instanceof IASTBinaryExpression) {
            this.writeBinaryExpression((IASTBinaryExpression)expression);
        } else if (expression instanceof IASTIdExpression) {
            ((IASTIdExpression)expression).getName().accept(this.visitor);
        } else if (expression instanceof IASTLiteralExpression) {
            this.writeLiteralExpression((IASTLiteralExpression)expression);
        } else if (expression instanceof IASTUnaryExpression) {
            this.writeUnaryExpression((IASTUnaryExpression)expression);
        } else if (expression instanceof IASTCastExpression) {
            this.writeCastExpression((IASTCastExpression)expression);
        } else if (expression instanceof ICPPASTNewExpression) {
            this.writeCPPNewExpression((ICPPASTNewExpression)expression);
        } else if (expression instanceof IASTConditionalExpression) {
            this.writeConditionalExpression((IASTConditionalExpression)expression);
        } else if (expression instanceof IASTArraySubscriptExpression) {
            this.writeArraySubscriptExpression((IASTArraySubscriptExpression)expression);
        } else if (expression instanceof IASTFieldReference) {
            this.writeFieldReference((IASTFieldReference)expression);
        } else if (expression instanceof IASTFunctionCallExpression) {
            this.writeFunctionCallExpression((IASTFunctionCallExpression)expression);
        } else if (expression instanceof IASTExpressionList) {
            this.writeExpressionList((IASTExpressionList)expression);
        } else {
            if (expression instanceof IASTProblemExpression) {
                throw new ProblemRuntimeException((IASTProblemExpression)expression);
            }
            if (expression instanceof IASTTypeIdExpression) {
                this.writeTypeIdExpression((IASTTypeIdExpression)expression);
            } else if (expression instanceof ICPPASTDeleteExpression) {
                this.writeDeleteExpression((ICPPASTDeleteExpression)expression);
            } else if (expression instanceof ICPPASTSimpleTypeConstructorExpression) {
                this.writeSimpleTypeConstructorExpression((ICPPASTSimpleTypeConstructorExpression)expression);
            } else if (expression instanceof ICPPASTLambdaExpression) {
                this.writeLambdaExpression((ICPPASTLambdaExpression)expression);
            }
        }
    }

    private String getBinaryExpressionOperator(int operator) {
        switch (operator) {
            case 1: {
                return MULTIPLY_OP;
            }
            case 2: {
                return DIVIDE_OP;
            }
            case 3: {
                return MODULO_OP;
            }
            case 4: {
                return PLUS_OP;
            }
            case 5: {
                return MINUS_OP;
            }
            case 6: {
                return SHIFT_LEFT_OP;
            }
            case 7: {
                return SHIFT_RIGHT_OP;
            }
            case 8: {
                return LESS_THAN_OP;
            }
            case 9: {
                return GREATER_THAN_OP;
            }
            case 10: {
                return LESS_EQUAL_OP;
            }
            case 11: {
                return GREAER_EQUAL_OP;
            }
            case 12: {
                return BINARY_AND_OP;
            }
            case 13: {
                return BINARY_XOR_OP;
            }
            case 14: {
                return BINARY_OR_OP;
            }
            case 15: {
                return LOGICAL_AND_OP;
            }
            case 16: {
                return LOGICAL_OR_OP;
            }
            case 17: {
                return " = ";
            }
            case 18: {
                return MULTIPLY_ASSIGN_OP;
            }
            case 19: {
                return DIVIDE_ASSIGN_OP;
            }
            case 20: {
                return MODULO_ASSIGN_OP;
            }
            case 21: {
                return PLUS_ASSIGN_OP;
            }
            case 22: {
                return MINUS_ASSIGN_OP;
            }
            case 23: {
                return SHIFT_LEFT_ASSIGN_OP;
            }
            case 24: {
                return SHIFT_RIGHT_ASSIGN_OP;
            }
            case 25: {
                return BINARY_AND_ASSIGN_OP;
            }
            case 26: {
                return BINARY_XOR_ASSIGN_OP;
            }
            case 27: {
                return BINARY_OR_ASSIGN;
            }
            case 28: {
                return EQUALS_OP;
            }
            case 29: {
                return NOT_EQUALS_OP;
            }
            case 30: {
                return PMDOT_OP;
            }
            case 31: {
                return PMARROW_OP;
            }
            case 32: {
                return MAX_OP;
            }
            case 33: {
                return MIN_OP;
            }
            case 34: {
                return ELLIPSES;
            }
        }
        System.err.println("Unknown unaryExpressionType: " + operator);
        throw new IllegalArgumentException("Unknown unaryExpressionType: " + operator);
    }

    private boolean isPrefixExpression(IASTUnaryExpression unExp) {
        int unaryExpressionType = unExp.getOperator();
        switch (unaryExpressionType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private boolean isPostfixExpression(IASTUnaryExpression unExp) {
        int unaryExpressionType = unExp.getOperator();
        switch (unaryExpressionType) {
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private String getPrefixOperator(IASTUnaryExpression unExp) {
        int unaryExpressionType = unExp.getOperator();
        switch (unaryExpressionType) {
            case 1: {
                return DECREMENT_OP;
            }
            case 0: {
                return INCREMENT_OP;
            }
            case 2: {
                return UNARY_PLUS_OP;
            }
            case 3: {
                return UNARY_MINUS_OP;
            }
            case 4: {
                return STAR_OP;
            }
            case 5: {
                return AMPERSAND_OP;
            }
            case 6: {
                return TILDE_OP;
            }
            case 7: {
                return NOT_OP;
            }
            case 8: {
                return SIZEOF_OP;
            }
            case 16: {
                return SIZEOF_PARAMETER_PACK_OP;
            }
            case 11: {
                return OPEN_BRACKET_OP;
            }
            case 12: {
                return THROW;
            }
            case 13: {
                return TYPEID_OP;
            }
            case 15: {
                return ALIGNOF_OP;
            }
        }
        System.err.println("Unkwown unaryExpressionType: " + unaryExpressionType);
        throw new IllegalArgumentException("Unkwown unaryExpressionType: " + unaryExpressionType);
    }

    private String getPostfixOperator(IASTUnaryExpression unExp) {
        int unaryExpressionType = unExp.getOperator();
        switch (unaryExpressionType) {
            case 10: {
                return DECREMENT_OP;
            }
            case 9: {
                return INCREMENT_OP;
            }
            case 13: {
                return CLOSING_BRACKET_OP;
            }
            case 11: 
            case 15: {
                return CLOSING_BRACKET_OP;
            }
        }
        System.err.println("Unkwown unaryExpressionType " + unaryExpressionType);
        throw new IllegalArgumentException("Unkwown unaryExpressionType " + unaryExpressionType);
    }

    private void writeBinaryExpression(IASTBinaryExpression binExp) {
        IASTExpression operand2;
        IASTExpression operand1 = binExp.getOperand1();
        if (!this.macroHandler.checkisMacroExpansionNode(operand1)) {
            operand1.accept(this.visitor);
        }
        if (this.macroHandler.checkisMacroExpansionNode(operand2 = binExp.getOperand2(), false) && this.macroHandler.macroExpansionAlreadyPrinted(operand2)) {
            return;
        }
        this.scribe.print(this.getBinaryExpressionOperator(binExp.getOperator()));
        operand2.accept(this.visitor);
    }

    private void writeCPPNewExpression(ICPPASTNewExpression newExp) {
        if (newExp.isGlobal()) {
            this.scribe.print("::");
        }
        this.scribe.print(NEW);
        IASTInitializerClause[] placement = newExp.getPlacementArguments();
        if (placement != null) {
            this.writeArgumentList(placement);
        }
        IASTTypeId typeId = newExp.getTypeId();
        this.visitNodeIfNotNull(typeId);
        IASTInitializer initExp = this.getNewInitializer(newExp);
        if (initExp != null) {
            initExp.accept(this.visitor);
        }
    }

    protected IASTInitializer getNewInitializer(ICPPASTNewExpression newExp) {
        return newExp.getInitializer();
    }

    private void writeArgumentList(IASTInitializerClause[] args) {
        this.scribe.print(OPEN_BRACKET_OP);
        boolean needComma = false;
        IASTInitializerClause[] iASTInitializerClauseArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (needComma) {
                this.scribe.print(", ");
            }
            arg.accept(this.visitor);
            needComma = true;
            ++n2;
        }
        this.scribe.print(CLOSING_BRACKET_OP);
    }

    private void writeLiteralExpression(IASTLiteralExpression litExp) {
        this.scribe.print(litExp.toString());
    }

    private void writeUnaryExpression(IASTUnaryExpression unExp) {
        if (this.isPrefixExpression(unExp)) {
            this.scribe.print(this.getPrefixOperator(unExp));
        }
        this.visitNodeIfNotNull(unExp.getOperand());
        if (this.isPostfixExpression(unExp)) {
            this.scribe.print(this.getPostfixOperator(unExp));
        }
    }

    private void writeConditionalExpression(IASTConditionalExpression condExp) {
        condExp.getLogicalConditionExpression().accept(this.visitor);
        this.scribe.print(SPACE_QUESTIONMARK_SPACE);
        IASTExpression positiveExpression = condExp.getPositiveResultExpression();
        if (positiveExpression == null) {
            this.scribe.print(' ');
        } else {
            positiveExpression.accept(this.visitor);
        }
        this.scribe.print(" : ");
        condExp.getNegativeResultExpression().accept(this.visitor);
    }

    private void writeArraySubscriptExpression(IASTArraySubscriptExpression arrSubExp) {
        arrSubExp.getArrayExpression().accept(this.visitor);
        this.scribe.print('[');
        arrSubExp.getArgument().accept(this.visitor);
        this.scribe.print(']');
    }

    private void writeFieldReference(IASTFieldReference fieldRef) {
        ICPPASTFieldReference cppFieldRef;
        fieldRef.getFieldOwner().accept(this.visitor);
        if (fieldRef.isPointerDereference()) {
            this.scribe.print(ARROW);
        } else {
            this.scribe.print('.');
        }
        if (fieldRef instanceof ICPPASTFieldReference && (cppFieldRef = (ICPPASTFieldReference)fieldRef).isTemplate()) {
            this.scribe.printStringSpace("template");
        }
        fieldRef.getFieldName().accept(this.visitor);
    }

    private void writeFunctionCallExpression(IASTFunctionCallExpression funcCallExp) {
        funcCallExp.getFunctionNameExpression().accept(this.visitor);
        this.writeArgumentList(funcCallExp.getArguments());
    }

    private void writeCastExpression(IASTCastExpression castExp) {
        this.scribe.print(this.getCastPrefix(castExp.getOperator()));
        castExp.getTypeId().accept(this.visitor);
        this.scribe.print(this.getCastPostfix(castExp.getOperator()));
        if (castExp instanceof ICPPASTCastExpression) {
            this.scribe.print('(');
        }
        castExp.getOperand().accept(this.visitor);
        if (castExp instanceof ICPPASTCastExpression) {
            this.scribe.print(')');
        }
    }

    private String getCastPostfix(int castType) {
        switch (castType) {
            case 0: {
                return CLOSING_BRACKET_OP;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return CLOSING_CAST_BRACKET_OP;
            }
        }
        throw new IllegalArgumentException("Unknown Cast Type");
    }

    private String getCastPrefix(int castType) {
        switch (castType) {
            case 0: {
                return OPEN_BRACKET_OP;
            }
            case 4: {
                return CONST_CAST_OP;
            }
            case 1: {
                return DYNAMIC_CAST_OP;
            }
            case 3: {
                return REINTERPRET_CAST_OP;
            }
            case 2: {
                return STATIC_CAST_OP;
            }
        }
        throw new IllegalArgumentException("Unknown Cast Type");
    }

    private void writeExpressionList(IASTExpressionList expList) {
        IASTExpression[] expressions = expList.getExpressions();
        this.writeExpressions(expList, expressions);
    }

    protected void writeExpressions(IASTExpressionList expList, IASTExpression[] expressions) {
        this.writeNodeList(expressions);
    }

    private void writeTypeIdExpression(IASTTypeIdExpression typeIdExp) {
        this.scribe.print(this.getTypeIdExp(typeIdExp));
        typeIdExp.getTypeId().accept(this.visitor);
        this.scribe.print(')');
    }

    private String getTypeIdExp(IASTTypeIdExpression typeIdExp) {
        int type = typeIdExp.getOperator();
        switch (type) {
            case 0: {
                return "sizeof (";
            }
            case 1: {
                return TYPEID_OP;
            }
            case 2: {
                return "alignof ((";
            }
            case 3: {
                return TYPEOF_OP;
            }
        }
        throw new IllegalArgumentException("Unknown TypeId Type");
    }

    private void writeDeleteExpression(ICPPASTDeleteExpression delExp) {
        if (delExp.isGlobal()) {
            this.scribe.print("::");
        }
        this.scribe.print(DELETE);
        if (delExp.isVectored()) {
            this.scribe.print(VECTORED_DELETE_OP);
        }
        delExp.getOperand().accept(this.visitor);
    }

    private void writeSimpleTypeConstructorExpression(ICPPASTSimpleTypeConstructorExpression simpTypeCtorExp) {
        simpTypeCtorExp.getDeclSpecifier().accept(this.visitor);
        this.visitNodeIfNotNull(simpTypeCtorExp.getInitializer());
    }

    private void writeLambdaExpression(ICPPASTLambdaExpression lambdaExpression) {
        this.writeLambdaIntroducer(lambdaExpression);
        if (lambdaExpression.getDeclarator() != null) {
            lambdaExpression.getDeclarator().accept(this.visitor);
        }
        this.scribe.printSpace();
        lambdaExpression.getBody().accept(this.visitor);
    }

    private void writeLambdaIntroducer(ICPPASTLambdaExpression lambdaExpression) {
        this.scribe.print("[");
        ICPPASTLambdaExpression.CaptureDefault captureDefault = lambdaExpression.getCaptureDefault();
        if (captureDefault.equals((Object)ICPPASTLambdaExpression.CaptureDefault.BY_COPY)) {
            this.scribe.print('=');
        } else if (captureDefault.equals((Object)ICPPASTLambdaExpression.CaptureDefault.BY_REFERENCE)) {
            this.scribe.print('&');
        }
        ICPPASTCapture[] iCPPASTCaptureArray = lambdaExpression.getCaptures();
        int n = iCPPASTCaptureArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hasDefaultCapture;
            ICPPASTCapture capture = iCPPASTCaptureArray[n2];
            boolean isNotFirst = capture != lambdaExpression.getCaptures()[0];
            boolean bl = hasDefaultCapture = captureDefault != ICPPASTLambdaExpression.CaptureDefault.UNSPECIFIED;
            if (isNotFirst || hasDefaultCapture) {
                this.scribe.print(", ");
            }
            this.writeCapture(capture);
            ++n2;
        }
        this.scribe.print("]");
    }

    private void writeCapture(ICPPASTCapture capture) {
        if (capture.capturesThisPointer()) {
            this.scribe.print(THIS);
        } else {
            if (capture.isByReference()) {
                this.scribe.print(AMPERSAND_OP);
            }
            capture.getIdentifier().accept(this.visitor);
        }
    }
}

