/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.scannerconfig;

import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;

public class ManagedGCCScannerInfoConsoleParser
extends GCCScannerInfoConsoleParser {
    Boolean fManagedBuildOnState;

    public boolean processLine(String line) {
        if (this.isManagedBuildOn()) {
            return false;
        }
        return super.processLine(line);
    }

    public void shutdown() {
        if (!this.isManagedBuildOn()) {
            super.shutdown();
        }
        this.fManagedBuildOnState = null;
    }

    public void startup(IProject project, IScannerInfoCollector collector) {
        if (this.isManagedBuildOn()) {
            return;
        }
        super.startup(project, collector);
    }

    protected boolean isManagedBuildOn() {
        if (this.fManagedBuildOnState == null) {
            this.fManagedBuildOnState = this.doCalcManagedBuildOnState();
        }
        return this.fManagedBuildOnState;
    }

    protected boolean doCalcManagedBuildOnState() {
        IScannerInfoCollector cr = this.getCollector();
        if (!(cr instanceof PerProjectSICollector)) {
            return false;
        }
        InfoContext c = ((PerProjectSICollector)cr).getContext();
        IProject project = c.getProject();
        ICProjectDescription des = CoreModel.getDefault().getProjectDescription(project, false);
        CfgInfoContext cc = CfgInfoContext.fromInfoContext(des, c);
        if (cc != null) {
            IConfiguration cfg = cc.getConfiguration();
            return cfg.isManagedBuildOn();
        }
        return false;
    }
}

