/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class EnvVarBuildPath
implements IEnvVarBuildPath {
    private int fType;
    private String[] fVariableNames;
    private String fPathDelimiter;
    private IBuildPathResolver fBuildPathResolver;
    private IConfigurationElement fBuildPathResolverElement;

    public EnvVarBuildPath(ITool tool, IManagedConfigElement element) {
        this.loadFromManifest(element);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        this.setType(this.convertPathTypeToInt(element.getAttribute("pathType")));
        this.setVariableNames(SafeStringInterner.safeIntern((String)element.getAttribute("variableList")));
        this.setPathDelimiter(SafeStringInterner.safeIntern((String)element.getAttribute("pathDelimiter")));
        String buildPathResolver = element.getAttribute("buildPathResolver");
        if (buildPathResolver != null && element instanceof DefaultManagedConfigElement) {
            this.fBuildPathResolverElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    @Override
    public int getType() {
        return this.fType;
    }

    public void setType(int type) {
        this.fType = type;
    }

    @Override
    public String[] getVariableNames() {
        return this.fVariableNames;
    }

    public void setVariableNames(String[] names) {
        this.fVariableNames = names;
        this.fVariableNames = SafeStringInterner.safeIntern((String[])this.fVariableNames);
    }

    public void setVariableNames(String names) {
        this.setVariableNames(this.getNamesFromString(names));
    }

    public String[] getNamesFromString(String names) {
        if (names == null) {
            return null;
        }
        return names.split(",");
    }

    @Override
    public String getPathDelimiter() {
        return this.fPathDelimiter;
    }

    public void setPathDelimiter(String delimiter) {
        if (delimiter == null) {
            delimiter = ManagedBuildManager.getEnvironmentVariableProvider().getDefaultDelimiter();
        }
        this.fPathDelimiter = SafeStringInterner.safeIntern((String)delimiter);
    }

    private int convertPathTypeToInt(String pathType) {
        if (pathType != null && "buildpathLibrary".equals(pathType)) {
            return 2;
        }
        return 1;
    }

    private String convertPathTypeToString(int pathType) {
        switch (pathType) {
            case 2: {
                return "buildpathLibrary";
            }
        }
        return "buildpathInclude";
    }

    @Override
    public IBuildPathResolver getBuildPathResolver() {
        if (this.fBuildPathResolver == null && this.fBuildPathResolverElement != null) {
            try {
                if (this.fBuildPathResolverElement.getAttribute("buildPathResolver") != null) {
                    this.fBuildPathResolver = (IBuildPathResolver)this.fBuildPathResolverElement.createExecutableExtension("buildPathResolver");
                }
            }
            catch (CoreException coreException) {}
        }
        return this.fBuildPathResolver;
    }
}

