/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Collections;
import java.util.List;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SimplePushSpecPage
extends WizardPage {
    private boolean forceUpdate;
    private Text remoteRefName;
    private String sourceName;
    private Repository repository;
    protected RefContentAssistProvider assist;

    public SimplePushSpecPage(String niceSourceName, Repository repo) {
        super(UIText.SimplePushSpecPage_title);
        this.setTitle(UIText.SimplePushSpecPage_title);
        this.setMessage(NLS.bind((String)UIText.SimplePushSpecPage_message, (Object)niceSourceName));
        this.sourceName = niceSourceName;
        this.repository = repo;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        Composite inputPanel = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputPanel);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inputPanel.setLayout((Layout)layout);
        Label lblRemote = new Label(inputPanel, 0);
        lblRemote.setText(UIText.SimplePushSpecPage_TargetRefName);
        this.remoteRefName = new Text(inputPanel, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.remoteRefName);
        this.remoteRefName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimplePushSpecPage.this.setPageComplete(SimplePushSpecPage.this.isPageComplete());
            }
        });
        UIUtils.addRefContentProposalToText(this.remoteRefName, this.repository, new UIUtils.IRefListProvider(){

            @Override
            public List<Ref> getRefList() {
                if (SimplePushSpecPage.this.assist != null) {
                    return SimplePushSpecPage.this.assist.getRefsForContentAssist(false, true);
                }
                return Collections.emptyList();
            }
        });
        final Button forceButton = new Button(main, 32);
        forceButton.setText(UIText.RefSpecDialog_ForceUpdateCheckbox);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)forceButton);
        forceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimplePushSpecPage.this.forceUpdate = forceButton.getSelection();
            }
        });
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.remoteRefName.setFocus();
        }
    }

    protected void updateDestinationField() {
        this.setMessage(NLS.bind((String)UIText.SimplePushSpecPage_message, (Object)this.sourceName));
        String checkRemote = this.sourceName;
        if (this.sourceName.startsWith("refs/heads/")) {
            try {
                BranchTrackingStatus status = BranchTrackingStatus.of((Repository)this.repository, (String)this.sourceName.substring("refs/heads/".length()));
                if (status != null) {
                    checkRemote = status.getRemoteTrackingBranch();
                    checkRemote = "refs/heads/" + checkRemote.substring(checkRemote.indexOf(47, "refs/remotes/".length() + 1) + 1);
                    this.setMessage(NLS.bind((String)UIText.SimplePushSpecPage_pushAheadInfo, (Object[])new Object[]{this.sourceName, status.getAheadCount(), status.getRemoteTrackingBranch()}), 1);
                }
            }
            catch (Exception exception) {}
            if (this.assist == null) {
                if (checkRemote != null) {
                    this.remoteRefName.setText(checkRemote);
                }
                return;
            }
            if (checkRemote == null) {
                checkRemote = this.sourceName;
            }
            for (Ref ref : this.assist.getRefsForContentAssist(false, true)) {
                if (!ref.getName().equals(checkRemote)) continue;
                this.remoteRefName.setText(checkRemote);
            }
        }
    }

    public boolean isPageComplete() {
        return this.remoteRefName.getText().length() > 0;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public String getTargetRef() {
        return this.remoteRefName.getText();
    }
}

