/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.XMLUtils;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MacroSettingsProcessor
extends SettingsProcessor {
    public static final String SECTION_NAME = "org.eclipse.cdt.internal.ui.wizards.settingswizards.Macros";
    private static final String MACRO_ELEMENT = "macro";
    private static final String NAME_ELEMENT = "name";
    private static final String VALUE_ELEMENT = "value";

    @Override
    public Image getIcon() {
        return CUIPlugin.getImageDescriptorRegistry().get(CDTSharedImages.getImageDescriptor("icons/obj16/define_obj.gif"));
    }

    @Override
    public String getDisplayName() {
        return Messages.ProjectSettingsWizardPage_Processor_Macros;
    }

    @Override
    public String getSectionName() {
        return SECTION_NAME;
    }

    @Override
    protected int getSettingsType() {
        return 4;
    }

    @Override
    protected void writeSettings(ContentHandler content, ICLanguageSettingEntry setting) throws SettingsImportExportException {
        char[] name = setting.getName().toCharArray();
        char[] value = setting.getValue().toCharArray();
        try {
            content.startElement("", "", MACRO_ELEMENT, null);
            MacroSettingsProcessor.newline(content);
            content.startElement("", "", NAME_ELEMENT, null);
            content.characters(name, 0, name.length);
            content.endElement("", "", NAME_ELEMENT);
            content.startElement("", "", VALUE_ELEMENT, null);
            content.characters(value, 0, value.length);
            content.endElement("", "", VALUE_ELEMENT);
            MacroSettingsProcessor.newline(content);
            content.endElement("", "", MACRO_ELEMENT);
            MacroSettingsProcessor.newline(content);
        }
        catch (SAXException e) {
            throw new SettingsImportExportException(e);
        }
    }

    @Override
    protected void readSettings(ICLanguageSetting setting, Element language) throws SettingsImportExportException {
        ArrayList<CMacroEntry> macros = new ArrayList<CMacroEntry>();
        List<Element> macrosNodes = XMLUtils.extractChildElements(language, MACRO_ELEMENT);
        for (Element macroElement : macrosNodes) {
            String name = null;
            String value = null;
            NodeList nodeList = macroElement.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                switch (node.getNodeType()) {
                    case 3: {
                        Text text = (Text)node;
                        if (XMLUtils.isWhitespace(text.getData())) break;
                        throw new SettingsImportExportException("Unknown text: '" + text.getData() + "'");
                    }
                    case 1: {
                        Element element = (Element)node;
                        String tagName = element.getTagName();
                        if (name == null && tagName.equals(NAME_ELEMENT)) {
                            name = element.getTextContent();
                            break;
                        }
                        if (value == null && tagName.equals(VALUE_ELEMENT)) {
                            value = element.getTextContent();
                            break;
                        }
                        throw new SettingsImportExportException("Unknown or extra tag: " + tagName);
                    }
                    default: {
                        throw new SettingsImportExportException("Unknown node: " + node.getNodeName());
                    }
                }
                ++i;
            }
            if (name == null) {
                throw new SettingsImportExportException("There must be one <name> element");
            }
            if (value == null) {
                throw new SettingsImportExportException("There must be one <value> element");
            }
            macros.add(CDataUtil.createCMacroEntry(name, value, (int)0));
        }
        if (macros.isEmpty()) {
            return;
        }
        macros.addAll(setting.getSettingEntriesList(4));
        setting.setSettingEntries(4, macros);
    }
}

