/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.cdt.internal.ui.refactoring.DeleteFileChange;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;

public class CreateFileChange
extends ResourceChange {
    private String name;
    private final IPath path;
    private final String source;
    private final String encoding;

    public CreateFileChange(String name, IPath path, String source, String encoding) {
        this.name = name;
        this.path = path;
        this.source = source;
        this.encoding = encoding;
    }

    public CreateFileChange(IPath path, String source, String encoding) {
        this(null, path, source, encoding);
    }

    public IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
    }

    public String getName() {
        if (this.name == null) {
            return NLS.bind((String)Messages.CreateFileChange_CreateFile, (Object)this.path.toOSString());
        }
        return this.name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError(NLS.bind((String)Messages.CreateFileChange_UnknownLoc, (Object)file.getFullPath().toString()));
            return result;
        }
        if (file.exists()) {
            result.addFatalError(NLS.bind((String)Messages.CreateFileChange_FileExists, (Object)file.getFullPath().toString()));
            return result;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
        ByteArrayInputStream is = new ByteArrayInputStream(this.source.getBytes());
        file.create((InputStream)is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (this.encoding != null) {
            file.setCharset(this.encoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        return new DeleteFileChange(file.getFullPath());
    }

    public String getSource() {
        return this.source;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

