/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards.registries;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardDescriptor;
import org.eclipse.rse.ui.wizards.registries.RSEAbstractWizardRegistry;
import org.eclipse.rse.ui.wizards.registries.RSEWizardRegistryElement;
import org.eclipse.swt.graphics.Image;

public class RSEWizardDescriptor
extends RSEWizardRegistryElement
implements IRSEWizardDescriptor {
    private IWizard wizard;

    public RSEWizardDescriptor(RSEAbstractWizardRegistry wizardRegistry, IConfigurationElement element) {
        super(wizardRegistry, element);
        this.internalGetWizard();
    }

    private IWizard internalGetWizard() {
        if (this.wizard == null || this.wizard != null && this.wizard.getStartingPage() != null && this.wizard.getStartingPage().getControl() != null && this.wizard.getStartingPage().getControl().isDisposed()) {
            IConfigurationElement element = this.getConfigurationElement();
            try {
                this.wizard = (IWizard)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String message = "RSE new connection wizard failed creation (plugin: {0}, id: {1}).";
                message = MessageFormat.format(message, element.getContributor().getName(), element.getAttribute("id"));
                RSECorePlugin.getDefault().getLogger().logError(message, (Throwable)e);
            }
        }
        return this.wizard;
    }

    public boolean isValid() {
        return super.isValid() && this.wizard != null;
    }

    public IWizard getWizard() {
        return this.internalGetWizard();
    }

    public boolean canFinishEarly() {
        String canFinishEarly = this.getConfigurationElement().getAttribute("canFinishEarly");
        if (canFinishEarly != null) {
            return Boolean.TRUE.equals(Boolean.valueOf(canFinishEarly));
        }
        return false;
    }

    public String getCategoryId() {
        return this.getConfigurationElement().getAttribute("categoryId");
    }

    public String getDescription() {
        return this.getConfigurationElement().getAttribute("description");
    }

    public boolean hasPages() {
        String hasPages = this.getConfigurationElement().getAttribute("hasPages");
        if (hasPages != null) {
            return Boolean.TRUE.equals(Boolean.valueOf(hasPages));
        }
        return false;
    }

    public Image getImage() {
        return null;
    }
}

