/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.launch.ICudaRemoteDebugConstants;
import com.nvidia.cuda.ide.remote.ui.launch.RemoteLaunchHelper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.ResetAnalysisAction;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.ide.ViperIDEUtil;
import com.nvidia.viper.ide.launch.LaunchConfigurationAdapter;
import com.nvidia.viper.ide.launch.LaunchConfigurationEditorInput;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.SessionEditor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public final class CudaApplicationProfilingLaunch
extends AbstractCLaunchDelegate2 {
    public static final String ATTR_APITRACE = "nvvp.apiTraceProfiling";
    public static final String ATTR_CONCURRENT = "nvvp.concurrentProfiling";
    public static final String ATTR_ENVIRONMENT = "nvvp.environmentProfiling";
    public static final String ATTR_PROFILER_ON_START = "nvvp.startProfiling";
    public static final String ATTR_SESSION_FILE = "nvvp.filename";
    public static final String ATTR_TIMEOUT = "nvvp.timeout";
    public static final String ATTR_UVM = "nvvp.uvmProfiling";
    public static final String ATTR_APP_REPLAY = "nvvp.appReplay";
    public static final String ATTR_MULTI_PROCESS = "nvvp.multiProcess";
    public static final String ATTR_OPENACC = "nvvp.openaccProfiling";
    public static final String ATTR_THREADS = "nvvp.threadTracking";
    public static final String ATTR_CDP_BUFFER_SIZE = "nvvp.cdpbuffersize";
    public static final String ATTR_DEVICE_BUFFER_SIZE = "nvvp.devicebuffersize";

    private static boolean shouldUpload(ILaunchConfiguration configuration) throws CoreException {
        if (ViperIDEUtil.isRemoteLaunch(configuration)) {
            return ICudaRemoteDebugConstants.ExecutableTransferMode.fromLaunchConfiguration((ILaunchConfiguration)configuration) == ICudaRemoteDebugConstants.ExecutableTransferMode.Upload;
        }
        return false;
    }

    public CudaApplicationProfilingLaunch() {
        super(false);
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = LaunchUtils.verifyProgramPath((ILaunchConfiguration)config, (ICProject)project);
        LaunchUtils.verifyBinary((ILaunchConfiguration)config, (IPath)exePath);
        return exePath;
    }

    private boolean executableReady(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (CudaApplicationProfilingLaunch.shouldUpload(configuration)) {
            this.upload(configuration, monitor);
        } else if (monitor != null) {
            monitor.done();
        }
        return true;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Getting ready to launch", (int)-1);
        if (super.finalLaunchCheck(configuration, mode, (IProgressMonitor)m.newChild(1))) {
            return this.executableReady(configuration, mode, (IProgressMonitor)m.newChild(1));
        }
        m.worked(1);
        m.done();
        return false;
    }

    protected String getPluginID() {
        return "com.nvidia.viper.ide";
    }

    public void launch(final ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isRemote = !"org.eclipse.cdt.launch.applicationLaunchType".equals(configuration.getType().getIdentifier());
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    LaunchConfigurationEditorInput editorInput = new LaunchConfigurationEditorInput(configuration.getName(), isRemote);
                    Session session = null;
                    IEditorPart editor = activePage.findEditor((IEditorInput)editorInput);
                    if (editor != null) {
                        session = ((SessionEditor)editor).getSession();
                        new ResetAnalysisAction(session, false).run();
                    }
                    if (session == null) {
                        session = ViperIDEUtil.createSession(LaunchConfigurationAdapter.getLaunchConfigurationAdapter(configuration.getName(), isRemote));
                    }
                    editorInput.setSession(session);
                    session.setTimelines(null);
                    new RunAnalysisAction(session, true, RunAnalysisAction.ShowMode.GUIDED).run();
                    activePage.openEditor((IEditorInput)editorInput, "com.nvidia.viper.sessioneditor");
                    session.setName(configuration.getName());
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                catch (CoreException e) {
                    ViperExceptionHandler.handle((String)ViperMessages.New_Fail_Title, (String)ViperMessages.New_Fail_Message, (Exception)((Object)new ViperException((Throwable)e)));
                }
                catch (ViperException e) {
                    ViperExceptionHandler.handle((String)ViperMessages.New_Fail_Title, (String)ViperMessages.New_Fail_Message, (Exception)((Object)new ViperException((Throwable)e)));
                }
            }
        });
    }

    private void upload(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        try {
            IRemoteConnection connection = RemoteLaunchHelper.getRemoteConnection((ILaunchConfiguration)configuration, (IProgressMonitor)subMonitor.newChild(1));
            IPath exePath = this.checkBinaryDetails(configuration);
            RemoteLaunchHelper.uploadExecutable((IRemoteConnection)connection, (ILaunchConfiguration)configuration, (IPath)exePath, (IProgressMonitor)subMonitor.newChild(4));
        }
        finally {
            subMonitor.done();
        }
    }
}

