/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.connection.IRemoteShell;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public final class RemoteToolLaunchDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTRIBUTE_COMMAND = "command";
    public static final String ATTRIBUTE_CONNECTION = "connectionName";
    public static final String TYPE = "com.nvidia.cuda.ide.remote.connection.remoteTool";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Executing remote command", (int)-1);
        if (!"run".equals(mode)) {
            throw CoreUtil.coreException((String)"Unsupported launch mode: %s", (Object[])new Object[]{mode});
        }
        String connectionName = configuration.getAttribute(ATTRIBUTE_CONNECTION, null);
        if (CoreUtil.isNullOrEmpty((String)connectionName)) {
            throw CoreUtil.coreException((String)"Missing connection name", (Object[])new Object[0]);
        }
        IRemoteConnection connection = IRemoteConnectionsService.GetConnection.getConnection(connectionName, (IProgressMonitor)subMonitor.newChild(1));
        if (connection == null) {
            throw CoreUtil.coreException((String)"Connection %s is missing", (Object[])new Object[]{connectionName});
        }
        String command = configuration.getAttribute(ATTRIBUTE_COMMAND, null);
        if (CoreUtil.isNullOrEmpty((String)command)) {
            throw CoreUtil.coreException((String)"Command is missing", (Object[])new Object[0]);
        }
        IRemoteShell shell = connection.openShell((IProgressMonitor)subMonitor.newChild(1));
        IProcess process = shell.startProcess(configuration.getName(), launch, command, (IProgressMonitor)subMonitor.newChild(1));
        launch.addProcess(process);
    }
}

