/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.CalculationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.DateFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.DateTimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.JoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.NumberFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.elements.structures.OdaLevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.ParameterFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.elements.structures.ScriptLib;
import org.eclipse.birt.report.model.api.elements.structures.SearchKey;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.elements.structures.SortHint;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.elements.structures.StringFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.elements.structures.TimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.TimeInterval;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.ActionStructureState;
import org.eclipse.birt.report.model.parser.CompatibleComputedColumnStructureState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.EncryptedPropertyState;
import org.eclipse.birt.report.model.parser.ExpressionState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.SimplePropertyListState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.parser.XmlPropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.LineNumberInfo;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StructureState
extends AbstractPropertyState {
    protected int lineNumber = 1;
    protected List list = null;
    PropertyDefn propDefn = null;
    private static Map structDict = null;
    protected Structure parentStruct = null;

    StructureState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    StructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, Structure parentStruct) {
        super(theHandler, element);
        assert (propDefn != null);
        this.propDefn = propDefn;
        this.parentStruct = parentStruct;
        this.name = propDefn.getName();
    }

    StructureState(ModuleParserHandler theHandler, DesignElement element, Structure parentStruct) {
        super(theHandler, element);
        this.parentStruct = parentStruct;
    }

    StructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn) {
        super(theHandler, element);
        assert (propDefn != null);
        this.propDefn = propDefn;
        this.name = propDefn.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.propDefn = this.element.getPropertyDefn(name);
        this.createStructure();
    }

    private void createStructure() {
        if (this.struct == null) {
            assert (this.propDefn != null);
            this.struct = StructureState.createStructure((StructureDefn)this.propDefn.getStructDefn());
        }
    }

    @Override
    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.lineNumber = this.handler.getCurrentLineNo();
        String tmpName = this.getAttrib(attrs, "name");
        if (!StringUtil.isBlank(tmpName) && this.propDefn == null) {
            this.name = tmpName;
            this.propDefn = this.parentStruct == null ? this.element.getPropertyDefn(this.name) : (PropertyDefn)this.parentStruct.getMemberDefn(this.name);
        }
        if (this.propDefn == null || !this.propDefn.isList()) {
            if (StringUtil.isBlank(this.name)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.NAME_REQUIRED")));
                this.valid = false;
                return;
            }
            if (this.propDefn == null) {
                this.propDefn = this.parentStruct == null ? this.element.getPropertyDefn(this.name) : (PropertyDefn)this.parentStruct.getMemberDefn(this.name);
            }
        }
        if (this.propDefn == null) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.INVALID_STRUCTURE_NAME")));
            this.valid = false;
            return;
        }
        this.createStructure();
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
            return new PropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.ENCRYPTED_PROPERTY_TAG == tagValue) {
            return new EncryptedPropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.EXPRESSION_TAG == tagValue) {
            return new ExpressionState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.XML_PROPERTY_TAG == tagValue) {
            return new XmlPropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.LIST_PROPERTY_TAG == tagValue) {
            return new ListPropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.TEXT_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.element, this.struct);
        }
        if (ParserSchemaConstants.HTML_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.element, this.struct);
        }
        if (ParserSchemaConstants.STRUCTURE_TAG == tagValue) {
            return new StructureState(this.handler, this.element, (Structure)this.struct);
        }
        if (ParserSchemaConstants.SIMPLE_PROPERTY_LIST_TAG == tagValue) {
            return new SimplePropertyListState(this.handler, this.element, this.propDefn, this.struct);
        }
        return super.startElement(tagName);
    }

    @Override
    public void end() throws SAXException {
        if (this.handler.markLineNumber && LineNumberInfo.isLineNumberSuppoerted(this.struct)) {
            this.handler.tempLineNumbers.put(this.struct, this.lineNumber);
        }
        if (this.struct != null) {
            if (this.parentStruct != null) {
                StructureContext context = new StructureContext(this.parentStruct, this.propDefn, (Structure)this.struct);
                if (this.propDefn.isList()) {
                    context.add((Structure)this.struct);
                } else {
                    ((Structure)this.struct).setContext(context);
                    this.parentStruct.setProperty(this.propDefn, (Object)this.struct);
                }
            } else {
                StructureContext context = new StructureContext(this.element, (ElementPropertyDefn)this.propDefn, (Structure)this.struct);
                if (this.propDefn.isList()) {
                    context.add((Structure)this.struct);
                } else {
                    ((Structure)this.struct).setContext(context);
                    this.element.setProperty(this.name, (Object)this.struct);
                }
            }
        }
    }

    @Override
    protected AbstractParseState generalJumpTo() {
        String propName;
        if (this.element instanceof Label && "action".equalsIgnoreCase(this.name) || this.element instanceof ImageItem && "action".equalsIgnoreCase(this.name) || this.element instanceof DataItem && "action".equalsIgnoreCase(this.name)) {
            ActionStructureState state = new ActionStructureState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        String string = propName = this.propDefn == null ? null : this.propDefn.getName();
        if (this.element instanceof DataSet && "computedColumns".equalsIgnoreCase(propName)) {
            CompatibleComputedColumnStructureState state = new CompatibleComputedColumnStructureState(this.handler, this.element, this.propDefn);
            state.setName(propName);
            return state;
        }
        return super.generalJumpTo();
    }

    static IStructure createStructure(StructureDefn structDefn) {
        IStructure struct;
        block8: {
            Class c;
            block7: {
                StructureState.populateStructDict();
                assert (structDefn != null);
                assert (structDict != null);
                struct = null;
                c = (Class)structDict.get(structDefn.getName().toLowerCase());
                if (c != null) break block7;
                return null;
            }
            try {
                struct = (IStructure)c.newInstance();
            }
            catch (InstantiationException instantiationException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return struct;
    }

    private static synchronized void populateStructDict() {
        if (structDict != null) {
            return;
        }
        structDict = new HashMap();
        structDict.put("Action".toLowerCase(), Action.class);
        structDict.put("ColumnHint".toLowerCase(), ColumnHint.class);
        structDict.put("ComputedColumn".toLowerCase(), ComputedColumn.class);
        structDict.put("ConfigVar".toLowerCase(), ConfigVariable.class);
        structDict.put("CustomColor".toLowerCase(), CustomColor.class);
        structDict.put("EmbeddedImage".toLowerCase(), EmbeddedImage.class);
        structDict.put("FilterCondition".toLowerCase(), FilterCondition.class);
        structDict.put("HideRule".toLowerCase(), HideRule.class);
        structDict.put("HighlightRule".toLowerCase(), HighlightRule.class);
        structDict.put("IncludedLibrary".toLowerCase(), IncludedLibrary.class);
        structDict.put("IncludeScript".toLowerCase(), IncludeScript.class);
        structDict.put("DataSetParam".toLowerCase(), DataSetParameter.class);
        structDict.put("OdaDataSetParam".toLowerCase(), OdaDataSetParameter.class);
        structDict.put("MapRule".toLowerCase(), MapRule.class);
        structDict.put("ParamBinding".toLowerCase(), ParamBinding.class);
        structDict.put("PropertyMask".toLowerCase(), PropertyMask.class);
        structDict.put("ResultSetColumn".toLowerCase(), ResultSetColumn.class);
        structDict.put("SearchKey".toLowerCase(), SearchKey.class);
        structDict.put("SelectionChoice".toLowerCase(), SelectionChoice.class);
        structDict.put("SortKey".toLowerCase(), SortKey.class);
        structDict.put("CachedMetaData".toLowerCase(), CachedMetaData.class);
        structDict.put("StringFormatValue".toLowerCase(), StringFormatValue.class);
        structDict.put("NumberFormatValue".toLowerCase(), NumberFormatValue.class);
        structDict.put("TimeFormatValue".toLowerCase(), TimeFormatValue.class);
        structDict.put("DateFormatValue".toLowerCase(), DateFormatValue.class);
        structDict.put("DateTimeFormatValue".toLowerCase(), DateTimeFormatValue.class);
        structDict.put("ParameterFormatValue".toLowerCase(), ParameterFormatValue.class);
        structDict.put("FormatValue".toLowerCase(), FormatValue.class);
        structDict.put("PropertyBinding".toLowerCase(), PropertyBinding.class);
        structDict.put("JoinCondition".toLowerCase(), JoinCondition.class);
        structDict.put("OdaDesignerState".toLowerCase(), OdaDesignerState.class);
        structDict.put("OdaResultSetColumn".toLowerCase(), OdaResultSetColumn.class);
        structDict.put("ScriptLib".toLowerCase(), ScriptLib.class);
        structDict.put("IncludedCssStyleSheet".toLowerCase(), IncludedCssStyleSheet.class);
        structDict.put("TOCStructure".toLowerCase(), TOC.class);
        structDict.put("DimensionCondition".toLowerCase(), DimensionCondition.class);
        structDict.put("Rule".toLowerCase(), Rule.class);
        structDict.put("LevelAttribute".toLowerCase(), LevelAttribute.class);
        structDict.put("OdaLevelAttribute".toLowerCase(), OdaLevelAttribute.class);
        structDict.put("DimensionJoinCondition".toLowerCase(), DimensionJoinCondition.class);
        structDict.put("AggregationArgument".toLowerCase(), AggregationArgument.class);
        structDict.put("SortHint".toLowerCase(), SortHint.class);
        structDict.put("TimeInterval".toLowerCase(), TimeInterval.class);
        structDict.put("CalculationArgument".toLowerCase(), CalculationArgument.class);
    }
}

