/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class TomcatJarInputStream
extends JarInputStream {
    private JarEntry metaInfEntry;
    private JarEntry manifestEntry;

    TomcatJarInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected ZipEntry createZipEntry(String string) {
        ZipEntry zipEntry = super.createZipEntry(string);
        if (this.metaInfEntry == null && "META-INF/".equals(string)) {
            this.metaInfEntry = (JarEntry)zipEntry;
        } else if (this.manifestEntry == null && "META-INF/MANIFEST.MF".equals(string)) {
            this.manifestEntry = (JarEntry)zipEntry;
        }
        return zipEntry;
    }

    JarEntry getMetaInfEntry() {
        return this.metaInfEntry;
    }

    JarEntry getManifestEntry() {
        return this.manifestEntry;
    }
}

