/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.BeanNameELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.StaticFieldELResolver;
import java.beans.FeatureDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class CompositeELResolver
extends ELResolver {
    private static final Class<?> SCOPED_ATTRIBUTE_EL_RESOLVER;
    private static final Set<String> KNOWN_NON_TYPE_CONVERTING_RESOLVERS;
    private int resolversSize = 0;
    private ELResolver[] resolvers = new ELResolver[8];
    private int typeConvertersSize = 0;
    private ELResolver[] typeConverters = new ELResolver[0];

    public void add(ELResolver eLResolver) {
        ELResolver[] eLResolverArray;
        Objects.requireNonNull(eLResolver);
        if (this.resolversSize >= this.resolvers.length) {
            eLResolverArray = new ELResolver[this.resolversSize * 2];
            System.arraycopy(this.resolvers, 0, eLResolverArray, 0, this.resolversSize);
            this.resolvers = eLResolverArray;
        }
        this.resolvers[this.resolversSize++] = eLResolver;
        if (KNOWN_NON_TYPE_CONVERTING_RESOLVERS.contains(eLResolver.getClass().getName())) {
            return;
        }
        if (this.typeConvertersSize == 0) {
            this.typeConverters = new ELResolver[1];
        } else if (this.typeConvertersSize == this.typeConverters.length) {
            eLResolverArray = new ELResolver[this.typeConvertersSize * 2];
            System.arraycopy(this.typeConverters, 0, eLResolverArray, 0, this.typeConvertersSize);
            this.typeConverters = eLResolverArray;
        }
        this.typeConverters[this.typeConvertersSize++] = eLResolver;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        eLContext.setPropertyResolved(false);
        int n = this.resolversSize;
        for (int i = 0; i < n; ++i) {
            Object object3 = this.resolvers[i].getValue(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    @Override
    public Object invoke(ELContext eLContext, Object object, Object object2, Class<?>[] classArray, Object[] objectArray) {
        eLContext.setPropertyResolved(false);
        int n = this.resolversSize;
        for (int i = 0; i < n; ++i) {
            Object object3 = this.resolvers[i].invoke(eLContext, object, object2, classArray, objectArray);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        eLContext.setPropertyResolved(false);
        int n = this.resolversSize;
        for (int i = 0; i < n; ++i) {
            Object object3;
            Class<?> clazz = this.resolvers[i].getType(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            if (SCOPED_ATTRIBUTE_EL_RESOLVER != null && SCOPED_ATTRIBUTE_EL_RESOLVER.isAssignableFrom(this.resolvers[i].getClass()) && (object3 = this.resolvers[i].getValue(eLContext, object, object2)) != null) {
                return object3.getClass();
            }
            return clazz;
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        eLContext.setPropertyResolved(false);
        int n = this.resolversSize;
        for (int i = 0; i < n; ++i) {
            this.resolvers[i].setValue(eLContext, object, object2, object3);
            if (!eLContext.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        eLContext.setPropertyResolved(false);
        int n = this.resolversSize;
        for (int i = 0; i < n; ++i) {
            boolean bl = this.resolvers[i].isReadOnly(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            return bl;
        }
        return false;
    }

    @Override
    @Deprecated(forRemoval=true, since="EL 5.0")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return new FeatureIterator(eLContext, object, this.resolvers, this.resolversSize);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        Class<?> clazz = null;
        int n = this.resolversSize;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz2 = this.resolvers[i].getCommonPropertyType(eLContext, object);
            if (clazz2 == null || clazz != null && !clazz.isAssignableFrom(clazz2)) continue;
            clazz = clazz2;
        }
        return clazz;
    }

    @Override
    public <T> T convertToType(ELContext eLContext, Object object, Class<T> clazz) {
        eLContext.setPropertyResolved(false);
        int n = this.typeConvertersSize;
        for (int i = 0; i < n; ++i) {
            T t = this.typeConverters[i].convertToType(eLContext, object, clazz);
            if (!eLContext.isPropertyResolved()) continue;
            return t;
        }
        return null;
    }

    static {
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS = new HashSet<String>();
        Class<?> clazz = null;
        try {
            clazz = Class.forName("jakarta.servlet.jsp.el.ScopedAttributeELResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        SCOPED_ATTRIBUTE_EL_RESOLVER = clazz;
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(ArrayELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(BeanELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(BeanNameELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(ListELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(MapELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(ResourceBundleELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add(StaticFieldELResolver.class.getName());
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add("jakarta.servlet.jsp.el.ImplicitObjectELResolver");
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add("jakarta.servlet.jsp.el.ImportELResolver");
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add("jakarta.servlet.jsp.el.NotFoundELResolver");
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add("jakarta.servlet.jsp.el.ScopedAttributeELResolver");
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add("org.apache.jasper.el.JasperELResolver$GraalBeanELResolver");
        KNOWN_NON_TYPE_CONVERTING_RESOLVERS.add("org.apache.el.stream.StreamELResolverImpl");
    }

    @Deprecated(forRemoval=true, since="EL 5.0")
    private static final class FeatureIterator
    implements Iterator<FeatureDescriptor> {
        private final ELContext context;
        private final Object base;
        private final ELResolver[] resolvers;
        private final int size;
        private Iterator<FeatureDescriptor> itr;
        private int idx;
        private FeatureDescriptor next;

        FeatureIterator(ELContext eLContext, Object object, ELResolver[] eLResolverArray, int n) {
            this.context = eLContext;
            this.base = object;
            this.resolvers = eLResolverArray;
            this.size = n;
            this.idx = 0;
            this.guaranteeIterator();
        }

        private void guaranteeIterator() {
            while (this.itr == null && this.idx < this.size) {
                this.itr = this.resolvers[this.idx].getFeatureDescriptors(this.context, this.base);
                ++this.idx;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.itr != null) {
                while (this.next == null && this.itr.hasNext()) {
                    this.next = this.itr.next();
                }
            } else {
                return false;
            }
            if (this.next == null) {
                this.itr = null;
                this.guaranteeIterator();
            }
            return this.hasNext();
        }

        @Override
        public FeatureDescriptor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            FeatureDescriptor featureDescriptor = this.next;
            this.next = null;
            return featureDescriptor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

