/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DeploymentException;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Util;

public class PojoPathParam {
    private static final StringManager sm = StringManager.getManager(PojoPathParam.class);
    private final Class<?> type;
    private final String name;

    public PojoPathParam(Class<?> clazz, String string) throws DeploymentException {
        if (string != null) {
            PojoPathParam.validateType(clazz);
        }
        this.type = clazz;
        this.name = string;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    private static void validateType(Class<?> clazz) throws DeploymentException {
        if (String.class == clazz) {
            return;
        }
        if (Util.isPrimitive(clazz)) {
            return;
        }
        throw new DeploymentException(sm.getString("pojoPathParam.wrongType", new Object[]{clazz.getName()}));
    }
}

