/* manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "pamac-gtk.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pamac.h>
#include <adwaita.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include <gio/gdesktopappinfo.h>

#define VERSION "11.7.3-6"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_MANAGER (pamac_manager_get_type ())
#define PAMAC_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_MANAGER, PamacManager))
#define PAMAC_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_MANAGER, PamacManagerClass))
#define PAMAC_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_MANAGER))
#define PAMAC_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_MANAGER))
#define PAMAC_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_MANAGER, PamacManagerClass))

typedef struct _PamacManager PamacManager;
typedef struct _PamacManagerClass PamacManagerClass;
typedef struct _PamacManagerPrivate PamacManagerPrivate;

#define PAMAC_TYPE_SEARCH_PROVIDER (pamac_search_provider_get_type ())
#define PAMAC_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProvider))
#define PAMAC_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProviderClass))
#define PAMAC_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_SEARCH_PROVIDER))
#define PAMAC_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_SEARCH_PROVIDER))
#define PAMAC_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_SEARCH_PROVIDER, PamacSearchProviderClass))

typedef struct _PamacSearchProvider PamacSearchProvider;
typedef struct _PamacSearchProviderClass PamacSearchProviderClass;
enum  {
	PAMAC_MANAGER_0_PROPERTY,
	PAMAC_MANAGER_NUM_PROPERTIES
};
static GParamSpec* pamac_manager_properties[PAMAC_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define PAMAC_TYPE_MANAGER_WINDOW (pamac_manager_window_get_type ())
#define PAMAC_MANAGER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindow))
#define PAMAC_MANAGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindowClass))
#define PAMAC_IS_MANAGER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_MANAGER_WINDOW))
#define PAMAC_IS_MANAGER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_MANAGER_WINDOW))
#define PAMAC_MANAGER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_MANAGER_WINDOW, PamacManagerWindowClass))

typedef struct _PamacManagerWindow PamacManagerWindow;
typedef struct _PamacManagerWindowClass PamacManagerWindowClass;
typedef struct _PamacManagerWindowPrivate PamacManagerWindowPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _PamacManager {
	GtkApplication parent_instance;
	PamacManagerPrivate * priv;
};

struct _PamacManagerClass {
	GtkApplicationClass parent_class;
};

struct _PamacManagerPrivate {
	PamacDatabaseGtk* database;
	PamacSearchProvider* search_provider;
	guint search_provider_id;
	gboolean version;
	gboolean updates;
	gchar* pkgname;
	gchar* app_id;
	gchar* search;
	GOptionEntry* options;
	gint options_length1;
	gint _options_size_;
};

struct _PamacManagerWindow {
	AdwApplicationWindow parent_instance;
	PamacManagerWindowPrivate * priv;
	GtkStack* main_stack;
	GtkButton* button_back;
	GtkStack* browse_stack;
	GtkButton* search_button;
	GtkSearchEntry* search_entry;
	AdwOverlaySplitView* browse_splitview;
	AdwViewStack* view_stack;
	AdwViewSwitcher* view_stack_switcher;
	GtkButton* details_button;
	GtkButton* apply_button;
	GtkRevealer* infobox_revealer;
	AdwViewSwitcherBar* switcher_bar;
	GQueue* display_package_queue;
	PamacTransactionGtk* transaction;
	PamacLocalConfig* local_config;
	gboolean important_details;
	gboolean transaction_running;
	gboolean generate_mirrors_list;
};

struct _PamacManagerWindowClass {
	AdwApplicationWindowClass parent_class;
};

static gint PamacManager_private_offset;
static gpointer pamac_manager_parent_class = NULL;

VALA_EXTERN GType pamac_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacManager, g_object_unref)
VALA_EXTERN GType pamac_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacSearchProvider, g_object_unref)
VALA_EXTERN guint pamac_search_provider_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN PamacManager* pamac_manager_new (PamacDatabaseGtk* database);
VALA_EXTERN PamacManager* pamac_manager_construct (GType object_type,
                                       PamacDatabaseGtk* database);
VALA_EXTERN PamacSearchProvider* pamac_search_provider_new (PamacDatabase* database);
VALA_EXTERN PamacSearchProvider* pamac_search_provider_construct (GType object_type,
                                                      PamacDatabase* database);
static void __lambda90_ (PamacManager* self,
                  const gchar* app_id,
                  guint32 timestamp);
static void ___lambda90__pamac_search_provider_show_details (PamacSearchProvider* _sender,
                                                      const gchar* app_id,
                                                      guint32 timestamp,
                                                      gpointer self);
static void __lambda91_ (PamacManager* self,
                  gchar** terms,
                  gint terms_length1,
                  guint32 timestamp);
VALA_EXTERN GType pamac_manager_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacManagerWindow, g_object_unref)
static PamacManagerWindow* pamac_manager_get_manager_window (PamacManager* self);
VALA_EXTERN void pamac_manager_window_on_search_entry_activated (PamacManagerWindow* self);
static void ___lambda91__pamac_search_provider_search_full (PamacSearchProvider* _sender,
                                                     gchar** terms,
                                                     gint terms_length1,
                                                     guint32 timestamp,
                                                     gpointer self);
static void pamac_manager_real_startup (GApplication* base);
static void __lambda92_ (PamacManager* self);
static void ___lambda92__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda93_ (PamacManager* self,
                  GVariant* parameter);
VALA_EXTERN void pamac_manager_window_display_package_details (PamacManagerWindow* self,
                                                   PamacAlpmPackage* pkg);
static void ___lambda93__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda94_ (PamacManager* self,
                  GVariant* parameter);
VALA_EXTERN void pamac_manager_window_display_details (PamacManagerWindow* self,
                                           PamacPackage* pkg);
static void ___lambda94__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda95_ (PamacManager* self,
                  GVariant* parameter);
static void ___lambda95__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
VALA_EXTERN PamacManagerWindow* pamac_manager_window_new (GtkApplication* application,
                                              PamacDatabaseGtk* database);
VALA_EXTERN PamacManagerWindow* pamac_manager_window_construct (GType object_type,
                                                    GtkApplication* application,
                                                    PamacDatabaseGtk* database);
static gboolean pamac_manager_real_dbus_register (GApplication* base,
                                           GDBusConnection* connection,
                                           const gchar* object_path,
                                           GError** error);
static void pamac_manager_real_dbus_unregister (GApplication* base,
                                         GDBusConnection* connection,
                                         const gchar* object_path);
static void pamac_manager_real_activate (GApplication* base);
VALA_EXTERN void pamac_manager_window_refresh_packages_list (PamacManagerWindow* self);
static gint pamac_manager_real_handle_local_options (GApplication* base,
                                              GVariantDict* options);
static void pamac_manager_real_open (GApplication* base,
                              GFile** files,
                              gint files_length1,
                              const gchar* hint);
static void pamac_manager_real_shutdown (GApplication* base);
static gboolean pamac_manager_check_pamac_running (PamacManager* self);
static void pamac_manager_finalize (GObject * obj);
static GType pamac_manager_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);

static inline gpointer
pamac_manager_get_instance_private (PamacManager* self)
{
	return G_STRUCT_MEMBER_P (self, PamacManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda90_ (PamacManager* self,
             const gchar* app_id,
             guint32 timestamp)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (app_id != NULL);
	_tmp0_ = g_variant_new ("s", app_id, NULL);
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) self, "details-id", _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

static void
___lambda90__pamac_search_provider_show_details (PamacSearchProvider* _sender,
                                                 const gchar* app_id,
                                                 guint32 timestamp,
                                                 gpointer self)
{
	__lambda90_ ((PamacManager*) self, app_id, timestamp);
}

static void
__lambda91_ (PamacManager* self,
             gchar** terms,
             gint terms_length1,
             guint32 timestamp)
{
	GString* str_builder = NULL;
	GString* _tmp0_;
	PamacManagerWindow* manager_window = NULL;
	PamacManagerWindow* _tmp5_;
	GQueue* _tmp6_;
	GtkButton* _tmp7_;
	GtkSearchEntry* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	_tmp0_ = g_string_new ("");
	str_builder = _tmp0_;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = terms;
		str_collection_length1 = terms_length1;
		for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
			const gchar* str = NULL;
			str = str_collection[str_it];
			{
				GString* _tmp1_;
				GString* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = str_builder;
				if (_tmp1_->len > ((gssize) 0)) {
					GString* _tmp2_;
					_tmp2_ = str_builder;
					g_string_append (_tmp2_, " ");
				}
				_tmp3_ = str_builder;
				_tmp4_ = str;
				g_string_append (_tmp3_, _tmp4_);
			}
		}
	}
	_tmp5_ = pamac_manager_get_manager_window (self);
	manager_window = _tmp5_;
	_tmp6_ = manager_window->display_package_queue;
	g_queue_clear (_tmp6_);
	_tmp7_ = manager_window->search_button;
	g_signal_emit_by_name (_tmp7_, "clicked");
	_tmp8_ = manager_window->search_entry;
	_tmp9_ = str_builder;
	_tmp10_ = _tmp9_->str;
	gtk_editable_set_text ((GtkEditable*) _tmp8_, _tmp10_);
	pamac_manager_window_on_search_entry_activated (manager_window);
	gtk_window_present_with_time ((GtkWindow*) manager_window, timestamp);
	_g_object_unref0 (manager_window);
	_g_string_free0 (str_builder);
}

static void
___lambda91__pamac_search_provider_search_full (PamacSearchProvider* _sender,
                                                gchar** terms,
                                                gint terms_length1,
                                                guint32 timestamp,
                                                gpointer self)
{
	__lambda91_ ((PamacManager*) self, terms, terms_length1, timestamp);
}

PamacManager*
pamac_manager_construct (GType object_type,
                         PamacDatabaseGtk* database)
{
	PamacManager * self = NULL;
	PamacDatabaseGtk* _tmp0_;
	GOptionEntry* _tmp1_;
	GOptionEntry* _tmp2_;
	gint _tmp2__length1;
	GOptionEntry _tmp3_ = {0};
	GOptionEntry* _tmp4_;
	gint _tmp4__length1;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry* _tmp6_;
	gint _tmp6__length1;
	GOptionEntry _tmp7_ = {0};
	GOptionEntry* _tmp8_;
	gint _tmp8__length1;
	GOptionEntry _tmp9_ = {0};
	GOptionEntry* _tmp10_;
	gint _tmp10__length1;
	GOptionEntry _tmp11_ = {0};
	GOptionEntry* _tmp12_;
	gint _tmp12__length1;
	PamacSearchProvider* _tmp13_;
	PamacSearchProvider* _tmp14_;
	PamacSearchProvider* _tmp15_;
	g_return_val_if_fail (database != NULL, NULL);
	self = (PamacManager*) g_object_new (object_type, "application-id", "org.manjaro.pamac.manager", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	_tmp0_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	self->priv->version = FALSE;
	self->priv->updates = FALSE;
	_g_free0 (self->priv->pkgname);
	self->priv->pkgname = NULL;
	_g_free0 (self->priv->app_id);
	self->priv->app_id = NULL;
	_g_free0 (self->priv->search);
	self->priv->search = NULL;
	_tmp1_ = g_new0 (GOptionEntry, 6);
	self->priv->options = (g_free (self->priv->options), NULL);
	self->priv->options = _tmp1_;
	self->priv->options_length1 = 6;
	self->priv->_options_size_ = self->priv->options_length1;
	_tmp2_ = self->priv->options;
	_tmp2__length1 = self->priv->options_length1;
	_tmp3_.long_name = "version";
	_tmp3_.short_name = (gchar) 0;
	_tmp3_.flags = (gint) 0;
	_tmp3_.arg = G_OPTION_ARG_NONE;
	_tmp3_.arg_data = &self->priv->version;
	_tmp3_.description = "Display version number";
	_tmp3_.arg_description = NULL;
	_tmp2_[0] = _tmp3_;
	_tmp4_ = self->priv->options;
	_tmp4__length1 = self->priv->options_length1;
	_tmp5_.long_name = "updates";
	_tmp5_.short_name = (gchar) 0;
	_tmp5_.flags = (gint) 0;
	_tmp5_.arg = G_OPTION_ARG_NONE;
	_tmp5_.arg_data = &self->priv->updates;
	_tmp5_.description = "Display updates";
	_tmp5_.arg_description = NULL;
	_tmp4_[1] = _tmp5_;
	_tmp6_ = self->priv->options;
	_tmp6__length1 = self->priv->options_length1;
	_tmp7_.long_name = "details";
	_tmp7_.short_name = (gchar) 0;
	_tmp7_.flags = (gint) 0;
	_tmp7_.arg = G_OPTION_ARG_STRING;
	_tmp7_.arg_data = &self->priv->pkgname;
	_tmp7_.description = "Display package details";
	_tmp7_.arg_description = "PACKAGE_NAME";
	_tmp6_[2] = _tmp7_;
	_tmp8_ = self->priv->options;
	_tmp8__length1 = self->priv->options_length1;
	_tmp9_.long_name = "details-id";
	_tmp9_.short_name = (gchar) 0;
	_tmp9_.flags = (gint) 0;
	_tmp9_.arg = G_OPTION_ARG_STRING;
	_tmp9_.arg_data = &self->priv->app_id;
	_tmp9_.description = "Display package details";
	_tmp9_.arg_description = "APP_ID";
	_tmp8_[3] = _tmp9_;
	_tmp10_ = self->priv->options;
	_tmp10__length1 = self->priv->options_length1;
	_tmp11_.long_name = "search";
	_tmp11_.short_name = (gchar) 0;
	_tmp11_.flags = (gint) 0;
	_tmp11_.arg = G_OPTION_ARG_STRING;
	_tmp11_.arg_data = &self->priv->search;
	_tmp11_.description = "Search packages";
	_tmp11_.arg_description = "SEARCH";
	_tmp10_[4] = _tmp11_;
	_tmp12_ = self->priv->options;
	_tmp12__length1 = self->priv->options_length1;
	g_application_add_main_option_entries ((GApplication*) self, _tmp12_);
	self->priv->search_provider_id = (guint) 0;
	_tmp13_ = pamac_search_provider_new ((PamacDatabase*) database);
	_g_object_unref0 (self->priv->search_provider);
	self->priv->search_provider = _tmp13_;
	_tmp14_ = self->priv->search_provider;
	g_signal_connect_object (_tmp14_, "show-details", (GCallback) ___lambda90__pamac_search_provider_show_details, self, 0);
	_tmp15_ = self->priv->search_provider;
	g_signal_connect_object (_tmp15_, "search-full", (GCallback) ___lambda91__pamac_search_provider_search_full, self, 0);
	return self;
}

PamacManager*
pamac_manager_new (PamacDatabaseGtk* database)
{
	return pamac_manager_construct (PAMAC_TYPE_MANAGER, database);
}

static void
__lambda92_ (PamacManager* self)
{
	PamacManagerWindow* manager_window = NULL;
	PamacManagerWindow* _tmp0_;
	GQueue* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	AdwViewStack* _tmp4_;
	_tmp0_ = pamac_manager_get_manager_window (self);
	manager_window = _tmp0_;
	_tmp1_ = manager_window->display_package_queue;
	g_queue_clear (_tmp1_);
	_tmp2_ = manager_window->main_stack;
	gtk_stack_set_visible_child_name (_tmp2_, "browse");
	_tmp3_ = manager_window->browse_stack;
	gtk_stack_set_visible_child_name (_tmp3_, "packages");
	_tmp4_ = manager_window->view_stack;
	adw_view_stack_set_visible_child_name (_tmp4_, "updates");
	g_action_group_activate_action ((GActionGroup*) manager_window, "back", NULL);
	gtk_window_present ((GtkWindow*) manager_window);
	_g_object_unref0 (manager_window);
}

static void
___lambda92__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda92_ ((PamacManager*) self);
}

static void
__lambda93_ (PamacManager* self,
             GVariant* parameter)
{
	PamacManagerWindow* manager_window = NULL;
	PamacManagerWindow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	PamacAlpmPackage* pkg = NULL;
	PamacDatabaseGtk* _tmp3_;
	const gchar* _tmp4_;
	PamacAlpmPackage* _tmp5_;
	PamacAlpmPackage* _tmp6_;
	PamacAlpmPackage* _tmp7_;
	PamacManagerWindow* _tmp20_;
	_tmp0_ = pamac_manager_get_manager_window (self);
	manager_window = _tmp0_;
	_tmp1_ = g_variant_get_string (parameter, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->pkgname);
	self->priv->pkgname = _tmp2_;
	_tmp3_ = self->priv->database;
	_tmp4_ = self->priv->pkgname;
	_tmp5_ = pamac_database_get_pkg ((PamacDatabase*) _tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	pkg = _tmp6_;
	_tmp7_ = pkg;
	if (_tmp7_ != NULL) {
		PamacManagerWindow* _tmp8_;
		PamacAlpmPackage* _tmp9_;
		PamacManagerWindow* _tmp10_;
		GtkStack* _tmp11_;
		PamacManagerWindow* _tmp12_;
		GtkStack* _tmp13_;
		PamacManagerWindow* _tmp14_;
		AdwViewSwitcher* _tmp15_;
		PamacManagerWindow* _tmp16_;
		GtkButton* _tmp17_;
		PamacManagerWindow* _tmp18_;
		GtkButton* _tmp19_;
		_tmp8_ = manager_window;
		_tmp9_ = pkg;
		pamac_manager_window_display_package_details (_tmp8_, _tmp9_);
		_tmp10_ = manager_window;
		_tmp11_ = _tmp10_->main_stack;
		gtk_stack_set_visible_child_name (_tmp11_, "browse");
		_tmp12_ = manager_window;
		_tmp13_ = _tmp12_->browse_stack;
		gtk_stack_set_visible_child_name (_tmp13_, "details");
		_tmp14_ = manager_window;
		_tmp15_ = _tmp14_->view_stack_switcher;
		gtk_widget_set_visible ((GtkWidget*) _tmp15_, FALSE);
		_tmp16_ = manager_window;
		_tmp17_ = _tmp16_->search_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp17_, FALSE);
		_tmp18_ = manager_window;
		_tmp19_ = _tmp18_->button_back;
		gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
	}
	_tmp20_ = manager_window;
	gtk_window_present ((GtkWindow*) _tmp20_);
	_g_object_unref0 (pkg);
	_g_object_unref0 (manager_window);
}

static void
___lambda93__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda93_ ((PamacManager*) self, parameter);
}

static void
__lambda94_ (PamacManager* self,
             GVariant* parameter)
{
	PamacManagerWindow* manager_window = NULL;
	PamacManagerWindow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	PamacPackage* pkg = NULL;
	PamacDatabaseGtk* _tmp3_;
	const gchar* _tmp4_;
	PamacPackage* _tmp5_;
	PamacPackage* _tmp6_;
	PamacPackage* _tmp7_;
	PamacManagerWindow* _tmp20_;
	_tmp0_ = pamac_manager_get_manager_window (self);
	manager_window = _tmp0_;
	_tmp1_ = g_variant_get_string (parameter, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->app_id);
	self->priv->app_id = _tmp2_;
	_tmp3_ = self->priv->database;
	_tmp4_ = self->priv->app_id;
	_tmp5_ = pamac_database_get_app_by_id ((PamacDatabase*) _tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	pkg = _tmp6_;
	_tmp7_ = pkg;
	if (_tmp7_ != NULL) {
		PamacManagerWindow* _tmp8_;
		PamacPackage* _tmp9_;
		PamacManagerWindow* _tmp10_;
		GtkStack* _tmp11_;
		PamacManagerWindow* _tmp12_;
		GtkStack* _tmp13_;
		PamacManagerWindow* _tmp14_;
		AdwViewSwitcher* _tmp15_;
		PamacManagerWindow* _tmp16_;
		GtkButton* _tmp17_;
		PamacManagerWindow* _tmp18_;
		GtkButton* _tmp19_;
		_tmp8_ = manager_window;
		_tmp9_ = pkg;
		pamac_manager_window_display_details (_tmp8_, _tmp9_);
		_tmp10_ = manager_window;
		_tmp11_ = _tmp10_->main_stack;
		gtk_stack_set_visible_child_name (_tmp11_, "browse");
		_tmp12_ = manager_window;
		_tmp13_ = _tmp12_->browse_stack;
		gtk_stack_set_visible_child_name (_tmp13_, "details");
		_tmp14_ = manager_window;
		_tmp15_ = _tmp14_->view_stack_switcher;
		gtk_widget_set_visible ((GtkWidget*) _tmp15_, FALSE);
		_tmp16_ = manager_window;
		_tmp17_ = _tmp16_->search_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp17_, FALSE);
		_tmp18_ = manager_window;
		_tmp19_ = _tmp18_->button_back;
		gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
	}
	_tmp20_ = manager_window;
	gtk_window_present ((GtkWindow*) _tmp20_);
	_g_object_unref0 (pkg);
	_g_object_unref0 (manager_window);
}

static void
___lambda94__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda94_ ((PamacManager*) self, parameter);
}

static void
__lambda95_ (PamacManager* self,
             GVariant* parameter)
{
	PamacManagerWindow* manager_window = NULL;
	PamacManagerWindow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GQueue* _tmp3_;
	GtkButton* _tmp4_;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	_tmp0_ = pamac_manager_get_manager_window (self);
	manager_window = _tmp0_;
	_tmp1_ = g_variant_get_string (parameter, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->search);
	self->priv->search = _tmp2_;
	_tmp3_ = manager_window->display_package_queue;
	g_queue_clear (_tmp3_);
	_tmp4_ = manager_window->search_button;
	g_signal_emit_by_name (_tmp4_, "clicked");
	_tmp5_ = manager_window->search_entry;
	_tmp6_ = self->priv->search;
	gtk_editable_set_text ((GtkEditable*) _tmp5_, _tmp6_);
	gtk_window_present ((GtkWindow*) manager_window);
	_g_object_unref0 (manager_window);
}

static void
___lambda95__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda95_ ((PamacManager*) self, parameter);
}

static void
pamac_manager_real_startup (GApplication* base)
{
	PamacManager * self;
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GVariantType* _tmp3_;
	GVariantType* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GVariantType* _tmp13_;
	GVariantType* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	self = (PamacManager*) base;
	textdomain ("pamac");
	setlocale (LC_ALL, "");
	G_APPLICATION_CLASS (pamac_manager_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	adw_init ();
	_tmp0_ = g_simple_action_new ("updates", NULL);
	action = _tmp0_;
	_tmp1_ = action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda92__g_simple_action_activate, self, 0);
	_tmp2_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = g_variant_type_new ("s");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_simple_action_new ("details", _tmp4_);
	_g_object_unref0 (action);
	action = _tmp5_;
	_g_variant_type_free0 (_tmp4_);
	_tmp6_ = action;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) ___lambda93__g_simple_action_activate, self, 0);
	_tmp7_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp7_);
	_tmp8_ = g_variant_type_new ("s");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_simple_action_new ("details-id", _tmp9_);
	_g_object_unref0 (action);
	action = _tmp10_;
	_g_variant_type_free0 (_tmp9_);
	_tmp11_ = action;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) ___lambda94__g_simple_action_activate, self, 0);
	_tmp12_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp12_);
	_tmp13_ = g_variant_type_new ("s");
	_tmp14_ = _tmp13_;
	_tmp15_ = g_simple_action_new ("search", _tmp14_);
	_g_object_unref0 (action);
	action = _tmp15_;
	_g_variant_type_free0 (_tmp14_);
	_tmp16_ = action;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) ___lambda95__g_simple_action_activate, self, 0);
	_tmp17_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp17_);
	_g_object_unref0 (action);
}

static PamacManagerWindow*
pamac_manager_get_manager_window (PamacManager* self)
{
	PamacManagerWindow* manager_window = NULL;
	GtkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	PamacManagerWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		PamacDatabaseGtk* _tmp3_;
		PamacManagerWindow* _tmp4_;
		PamacDatabaseGtk* _tmp5_;
		PamacManagerWindow* _tmp6_;
		_tmp3_ = self->priv->database;
		_tmp4_ = pamac_manager_window_new ((GtkApplication*) self, _tmp3_);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (manager_window);
		manager_window = _tmp4_;
		_tmp5_ = self->priv->database;
		_tmp6_ = manager_window;
		pamac_database_gtk_set_window (_tmp5_, (GtkWindow*) _tmp6_);
	} else {
		GtkWindow* _tmp7_;
		PamacManagerWindow* _tmp8_;
		_tmp7_ = window;
		_tmp8_ = _g_object_ref0 (PAMAC_IS_MANAGER_WINDOW (_tmp7_) ? ((PamacManagerWindow*) _tmp7_) : NULL);
		_g_object_unref0 (manager_window);
		manager_window = _tmp8_;
	}
	result = manager_window;
	return result;
}

static gboolean
pamac_manager_real_dbus_register (GApplication* base,
                                  GDBusConnection* connection,
                                  const gchar* object_path,
                                  GError** error)
{
	PamacManager * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PamacManager*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		guint _tmp0_ = 0U;
		gchar* _tmp1_;
		gchar* _tmp2_;
		PamacSearchProvider* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp1_ = g_strconcat (object_path, "/SearchProvider", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->search_provider;
		_tmp4_ = pamac_search_provider_register_object (_tmp3_, connection, _tmp2_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		self->priv->search_provider_id = _tmp0_;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("manager.vala:157: Could not register search provider service: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = TRUE;
	return result;
}

static void
pamac_manager_real_dbus_unregister (GApplication* base,
                                    GDBusConnection* connection,
                                    const gchar* object_path)
{
	PamacManager * self;
	self = (PamacManager*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	if (self->priv->search_provider_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (connection, self->priv->search_provider_id);
		self->priv->search_provider_id = (guint) 0;
	}
}

static void
pamac_manager_real_activate (GApplication* base)
{
	PamacManager * self;
	PamacManagerWindow* manager_window = NULL;
	PamacManagerWindow* _tmp0_;
	self = (PamacManager*) base;
	G_APPLICATION_CLASS (pamac_manager_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = pamac_manager_get_manager_window (self);
	manager_window = _tmp0_;
	pamac_manager_window_refresh_packages_list (manager_window);
	gtk_window_present ((GtkWindow*) manager_window);
	_g_object_unref0 (manager_window);
}

static gint
pamac_manager_real_handle_local_options (GApplication* base,
                                         GVariantDict* options)
{
	PamacManager * self;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (PamacManager*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (self->priv->version) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Pamac  %s\n", VERSION);
		result = 0;
		return result;
	} else {
		if (self->priv->updates) {
			{
				g_application_register ((GApplication*) self, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				g_action_group_activate_action ((GActionGroup*) self, "updates", NULL);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp1_;
				const gchar* _tmp2_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp1_ = e;
				_tmp2_ = _tmp1_->message;
				g_warning ("manager.vala:185: %s", _tmp2_);
				result = 0;
				_g_error_free0 (e);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp3_ = -1;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp3_;
			}
		} else {
			const gchar* _tmp4_;
			_tmp4_ = self->priv->pkgname;
			if (_tmp4_ != NULL) {
				{
					const gchar* _tmp5_;
					GVariant* _tmp6_;
					GVariant* _tmp7_;
					g_application_register ((GApplication*) self, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp5_ = self->priv->pkgname;
					_tmp6_ = g_variant_new ("s", _tmp5_, NULL);
					g_variant_ref_sink (_tmp6_);
					_tmp7_ = _tmp6_;
					g_action_group_activate_action ((GActionGroup*) self, "details", _tmp7_);
					_g_variant_unref0 (_tmp7_);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp8_;
					const gchar* _tmp9_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp8_ = e;
					_tmp9_ = _tmp8_->message;
					g_warning ("manager.vala:193: %s", _tmp9_);
					result = 0;
					_g_error_free0 (e);
					return result;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint _tmp10_ = -1;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp10_;
				}
			} else {
				const gchar* _tmp11_;
				_tmp11_ = self->priv->app_id;
				if (_tmp11_ != NULL) {
					{
						const gchar* _tmp12_;
						GVariant* _tmp13_;
						GVariant* _tmp14_;
						g_application_register ((GApplication*) self, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
						_tmp12_ = self->priv->app_id;
						_tmp13_ = g_variant_new ("s", _tmp12_, NULL);
						g_variant_ref_sink (_tmp13_);
						_tmp14_ = _tmp13_;
						g_action_group_activate_action ((GActionGroup*) self, "details-id", _tmp14_);
						_g_variant_unref0 (_tmp14_);
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* e = NULL;
						GError* _tmp15_;
						const gchar* _tmp16_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp15_ = e;
						_tmp16_ = _tmp15_->message;
						g_warning ("manager.vala:201: %s", _tmp16_);
						result = 0;
						_g_error_free0 (e);
						return result;
					}
					__finally2:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gint _tmp17_ = -1;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp17_;
					}
				} else {
					const gchar* _tmp18_;
					_tmp18_ = self->priv->search;
					if (_tmp18_ != NULL) {
						{
							const gchar* _tmp19_;
							GVariant* _tmp20_;
							GVariant* _tmp21_;
							g_application_register ((GApplication*) self, NULL, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch3_g_error;
							}
							_tmp19_ = self->priv->search;
							_tmp20_ = g_variant_new ("s", _tmp19_, NULL);
							g_variant_ref_sink (_tmp20_);
							_tmp21_ = _tmp20_;
							g_action_group_activate_action ((GActionGroup*) self, "search", _tmp21_);
							_g_variant_unref0 (_tmp21_);
						}
						goto __finally3;
						__catch3_g_error:
						{
							GError* e = NULL;
							GError* _tmp22_;
							const gchar* _tmp23_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp22_ = e;
							_tmp23_ = _tmp22_->message;
							g_warning ("manager.vala:209: %s", _tmp23_);
							result = 0;
							_g_error_free0 (e);
							return result;
						}
						__finally3:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							gint _tmp24_ = -1;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp24_;
						}
					}
				}
			}
		}
	}
	result = -1;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
pamac_manager_real_open (GApplication* base,
                         GFile** files,
                         gint files_length1,
                         const gchar* hint)
{
	PamacManager * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp12_;
	self = (PamacManager*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files[0];
	file = _tmp0_;
	_tmp1_ = file;
	if (g_file_has_uri_scheme (_tmp1_, "snap")) {
		gchar* app_id = NULL;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		_tmp2_ = file;
		_tmp3_ = g_file_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (_tmp4_, "snap:", "");
		_tmp6_ = _tmp5_;
		_tmp7_ = string_replace (_tmp6_, "/", "");
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		app_id = _tmp8_;
		_tmp9_ = app_id;
		_tmp10_ = g_variant_new ("s", _tmp9_, NULL);
		g_variant_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		g_action_group_activate_action ((GActionGroup*) self, "details-id", _tmp11_);
		_g_variant_unref0 (_tmp11_);
		_g_free0 (app_id);
		return;
	}
	_tmp12_ = file;
	if (g_file_has_uri_scheme (_tmp12_, "appstream")) {
		gchar* app_id = NULL;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		GVariant* _tmp21_;
		GVariant* _tmp22_;
		_tmp13_ = file;
		_tmp14_ = g_file_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_replace (_tmp15_, "appstream:", "");
		_tmp17_ = _tmp16_;
		_tmp18_ = string_replace (_tmp17_, "/", "");
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		app_id = _tmp19_;
		_tmp20_ = app_id;
		_tmp21_ = g_variant_new ("s", _tmp20_, NULL);
		g_variant_ref_sink (_tmp21_);
		_tmp22_ = _tmp21_;
		g_action_group_activate_action ((GActionGroup*) self, "details-id", _tmp22_);
		_g_variant_unref0 (_tmp22_);
		_g_free0 (app_id);
	} else {
		GVariant* _tmp23_;
		GVariant* _tmp24_;
		_tmp23_ = g_variant_new ("s", "", NULL);
		g_variant_ref_sink (_tmp23_);
		_tmp24_ = _tmp23_;
		g_action_group_activate_action ((GActionGroup*) self, "details", _tmp24_);
		_g_variant_unref0 (_tmp24_);
	}
}

static void
pamac_manager_real_shutdown (GApplication* base)
{
	PamacManager * self;
	GtkWindow* window = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (PamacManager*) base;
	G_APPLICATION_CLASS (pamac_manager_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	window = _tmp1_;
	if (!pamac_manager_check_pamac_running (self)) {
		GtkWindow* _tmp3_;
		_tmp3_ = window;
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		PamacManagerWindow* manager_window = NULL;
		PamacManagerWindow* _tmp4_;
		PamacManagerWindow* _tmp5_;
		PamacTransactionGtk* _tmp6_;
		_tmp4_ = pamac_manager_get_manager_window (self);
		manager_window = _tmp4_;
		_tmp5_ = manager_window;
		_tmp6_ = _tmp5_->transaction;
		pamac_transaction_quit_daemon ((PamacTransaction*) _tmp6_);
		_g_object_unref0 (manager_window);
	}
}

static gboolean
pamac_manager_check_pamac_running (PamacManager* self)
{
	GApplication* app = NULL;
	gboolean run = FALSE;
	GApplication* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	run = FALSE;
	_tmp0_ = g_application_new ("org.manjaro.pamac.installer", 0);
	_g_object_unref0 (app);
	app = _tmp0_;
	{
		g_application_register (app, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("manager.vala:250: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	run = g_application_get_is_remote (app);
	result = run;
	_g_object_unref0 (app);
	return result;
}

static void
pamac_manager_class_init (PamacManagerClass * klass,
                          gpointer klass_data)
{
	pamac_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacManager_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) pamac_manager_real_startup;
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) pamac_manager_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) pamac_manager_real_dbus_unregister;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) pamac_manager_real_activate;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) pamac_manager_real_handle_local_options;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) pamac_manager_real_open;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) pamac_manager_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = pamac_manager_finalize;
}

static void
pamac_manager_instance_init (PamacManager * self,
                             gpointer klass)
{
	self->priv = pamac_manager_get_instance_private (self);
}

static void
pamac_manager_finalize (GObject * obj)
{
	PamacManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_MANAGER, PamacManager);
	_g_object_unref0 (self->priv->database);
	_g_object_unref0 (self->priv->search_provider);
	_g_free0 (self->priv->pkgname);
	_g_free0 (self->priv->app_id);
	_g_free0 (self->priv->search);
	self->priv->options = (g_free (self->priv->options), NULL);
	G_OBJECT_CLASS (pamac_manager_parent_class)->finalize (obj);
}

static GType
pamac_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacManager), 0, (GInstanceInitFunc) pamac_manager_instance_init, NULL };
	GType pamac_manager_type_id;
	pamac_manager_type_id = g_type_register_static (gtk_application_get_type (), "PamacManager", &g_define_type_info, 0);
	PamacManager_private_offset = g_type_add_instance_private (pamac_manager_type_id, sizeof (PamacManagerPrivate));
	return pamac_manager_type_id;
}

GType
pamac_manager_get_type (void)
{
	static volatile gsize pamac_manager_type_id__once = 0;
	if (g_once_init_enter (&pamac_manager_type_id__once)) {
		GType pamac_manager_type_id;
		pamac_manager_type_id = pamac_manager_get_type_once ();
		g_once_init_leave (&pamac_manager_type_id__once, pamac_manager_type_id);
	}
	return pamac_manager_type_id__once;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	PamacConfig* config = NULL;
	PamacConfig* _tmp0_;
	PamacDatabaseGtk* database = NULL;
	PamacDatabaseGtk* _tmp1_;
	PamacManager* manager = NULL;
	PamacManager* _tmp2_;
	GDesktopAppInfo* appinfo = NULL;
	GDesktopAppInfo* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	_tmp0_ = pamac_config_new ("/etc/pamac.conf");
	config = _tmp0_;
	_tmp1_ = pamac_database_gtk_new (config);
	database = _tmp1_;
	_tmp2_ = pamac_manager_new (database);
	manager = _tmp2_;
	_tmp3_ = g_desktop_app_info_new ("org.manjaro.pamac.manager.desktop");
	appinfo = _tmp3_;
	_tmp4_ = g_app_info_get_name ((GAppInfo*) appinfo);
	g_set_application_name (_tmp4_);
	result = g_application_run ((GApplication*) manager, (gint) args_length1, args);
	_g_object_unref0 (appinfo);
	_g_object_unref0 (manager);
	_g_object_unref0 (database);
	_g_object_unref0 (config);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

