/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class AggregateBase
implements PlainJsonSerializable {
    @Nonnull
    private final Map<String, JsonData> meta;

    protected AggregateBase(AbstractBuilder<?> builder) {
        this.meta = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.meta);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateBase other = (AggregateBase)o;
        return Objects.equals(this.meta, other.meta);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private Map<String, JsonData> meta;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(AggregateBase o) {
            this.meta = AbstractBuilder._mapCopy(o.meta);
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.meta = AbstractBuilder._mapCopy(o.meta);
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT meta(Map<String, JsonData> map) {
            this.meta = AbstractBuilder._mapPutAll(this.meta, map);
            return this.self();
        }

        @Nonnull
        public final BuilderT meta(String key, JsonData value) {
            this.meta = AbstractBuilder._mapPut(this.meta, key, value);
            return this.self();
        }
    }
}

