/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.Randomness;
import org.opensearch.core.action.ActionListener;
import org.opensearch.transport.NodeDisconnectedException;
import org.opensearch.transport.NodeNotConnectedException;

public class RetryUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(RetryUtil.class);
    private static final int DEFAULT_MAX_RETRY = 3;
    private static final long DEFAULT_BASE_DELAY_MS = 500L;
    private static final List<Class<? extends Throwable>> RETRYABLE_EXCEPTIONS = ImmutableList.of(NodeNotConnectedException.class, NodeDisconnectedException.class);

    public static void handleRetryOrFailure(Exception e, int retryTime, Runnable retryAction, ActionListener<?> listener) {
        if (RetryUtil.shouldRetry(e, retryTime)) {
            long backoffTime = RetryUtil.calculateBackoffTime(retryTime);
            log.warn("Retrying connection for ML inference due to [{}] after [{}ms]", (Object)e.getMessage(), (Object)backoffTime, (Object)e);
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                listener.onFailure((Exception)interruptedException);
                return;
            }
            retryAction.run();
        } else {
            listener.onFailure(e);
        }
    }

    private static boolean shouldRetry(Exception e, int retryTime) {
        return RetryUtil.isRetryableException(e) && retryTime < 3;
    }

    private static boolean isRetryableException(Exception e) {
        return RETRYABLE_EXCEPTIONS.stream().anyMatch(x -> ExceptionUtils.indexOfThrowable((Throwable)e, (Class)x) != -1);
    }

    private static long calculateBackoffTime(int retryTime) {
        long backoffTime = 500L * (1L << retryTime);
        long jitter = Randomness.get().nextLong(10L, 50L);
        return backoffTime + jitter;
    }
}

