/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import lombok.Generated;
import org.opensearch.SpecialPermission;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.common.HttpRedirectValidator;
import org.opensearch.geospatial.shared.Constants;
import org.opensearch.secure_sm.AccessController;

public class DatasourceManifest {
    private static final ParseField URL_FIELD = new ParseField("url", new String[0]);
    private static final ParseField DB_NAME_FIELD = new ParseField("db_name", new String[0]);
    private static final ParseField SHA256_HASH_FIELD = new ParseField("sha256_hash", new String[0]);
    private static final ParseField VALID_FOR_IN_DAYS_FIELD = new ParseField("valid_for_in_days", new String[0]);
    private static final ParseField UPDATED_AT_FIELD = new ParseField("updated_at_in_epoch_milli", new String[0]);
    private static final ParseField PROVIDER_FIELD = new ParseField("provider", new String[0]);
    private String url;
    private String dbName;
    private String sha256Hash;
    private Long validForInDays;
    private Long updatedAt;
    private String provider;
    public static final ConstructingObjectParser<DatasourceManifest, Void> PARSER = new ConstructingObjectParser("datasource_manifest", true, args -> {
        String url = (String)args[0];
        String dbName = (String)args[1];
        String sha256Hash = (String)args[2];
        Long validForInDays = (Long)args[3];
        Long updatedAt = (Long)args[4];
        String provider = (String)args[5];
        return new DatasourceManifest(url, dbName, sha256Hash, validForInDays, updatedAt, provider);
    });

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    @Generated
    public void setSha256Hash(String sha256Hash) {
        this.sha256Hash = sha256Hash;
    }

    @Generated
    public void setValidForInDays(Long validForInDays) {
        this.validForInDays = validForInDays;
    }

    @Generated
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getDbName() {
        return this.dbName;
    }

    @Generated
    public String getSha256Hash() {
        return this.sha256Hash;
    }

    @Generated
    public Long getValidForInDays() {
        return this.validForInDays;
    }

    @Generated
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public DatasourceManifest(String url, String dbName, String sha256Hash, Long validForInDays, Long updatedAt, String provider) {
        this.url = url;
        this.dbName = dbName;
        this.sha256Hash = sha256Hash;
        this.validForInDays = validForInDays;
        this.updatedAt = updatedAt;
        this.provider = provider;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), URL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DB_NAME_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SHA256_HASH_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VALID_FOR_IN_DAYS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), UPDATED_AT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PROVIDER_FIELD);
    }

    public static class Builder {
        private static final int MANIFEST_FILE_MAX_BYTES = 8192;

        @SuppressForbidden(reason="Need to connect to http endpoint to read manifest file")
        public static DatasourceManifest build(URL url) {
            SpecialPermission.check();
            return (DatasourceManifest)AccessController.doPrivileged(() -> {
                try {
                    URLConnection connection = url.openConnection();
                    return Builder.internalBuild(connection);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        @VisibleForTesting
        @SuppressForbidden(reason="Need to connect to http endpoint to read manifest file")
        protected static DatasourceManifest internalBuild(URLConnection connection) throws IOException {
            connection.addRequestProperty("User-Agent", Constants.USER_AGENT_VALUE);
            if (connection instanceof HttpURLConnection) {
                HttpRedirectValidator.validateNoRedirects((HttpURLConnection)connection);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(connection.getInputStream());
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                CharBuffer charBuffer = CharBuffer.allocate(8192);
                reader.read(charBuffer);
                charBuffer.flip();
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, charBuffer.toString());
                DatasourceManifest datasourceManifest = (DatasourceManifest)PARSER.parse(parser, null);
                return datasourceManifest;
            }
        }
    }
}

