/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.BeanTypeAssignabilityRules;
import io.quarkus.arc.impl.CovariantTypes;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.impl.TypeCachePollutionUtils;
import io.quarkus.arc.impl.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;

final class EventTypeAssignabilityRules {
    private static final EventTypeAssignabilityRules INSTANCE = new EventTypeAssignabilityRules();

    public static EventTypeAssignabilityRules instance() {
        return INSTANCE;
    }

    private EventTypeAssignabilityRules() {
    }

    public boolean matches(Type observedType, Set<? extends Type> eventTypes) {
        for (Type type : eventTypes) {
            if (!this.matches(observedType, type)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Type observedType, Type eventType) {
        return this.matchesNoBoxing(Types.boxedType(observedType), Types.boxedType(eventType));
    }

    boolean matchesNoBoxing(Type observedType, Type eventType) {
        if (Types.isArray(observedType) && Types.isArray(eventType)) {
            Type observedComponentType = Types.getArrayComponentType(observedType);
            for (Type type : new HierarchyDiscovery(Types.getArrayComponentType(eventType)).getTypeClosure()) {
                if (!this.matchesNoBoxing(observedComponentType, type)) continue;
                return true;
            }
            return false;
        }
        if (observedType instanceof TypeVariable) {
            return this.matches((TypeVariable)observedType, eventType);
        }
        if (observedType instanceof Class && TypeCachePollutionUtils.isParameterizedType(eventType)) {
            return observedType.equals(Types.getRawType(eventType));
        }
        if (TypeCachePollutionUtils.isParameterizedType(observedType) && TypeCachePollutionUtils.isParameterizedType(eventType)) {
            return this.matches(TypeCachePollutionUtils.asParameterizedType(observedType), TypeCachePollutionUtils.asParameterizedType(eventType));
        }
        if (observedType instanceof Class && eventType instanceof Class) {
            return observedType.equals(eventType);
        }
        return false;
    }

    private boolean matches(TypeVariable<?> observedType, Type eventType) {
        BeanTypeAssignabilityRules.instance();
        for (Type bound : BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(observedType)) {
            if (CovariantTypes.isAssignableFrom(bound, eventType)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(ParameterizedType observedType, ParameterizedType eventType) {
        if (!observedType.getRawType().equals(eventType.getRawType())) {
            return false;
        }
        if (observedType.getActualTypeArguments().length != eventType.getActualTypeArguments().length) {
            throw new IllegalArgumentException("Invalid argument combination " + String.valueOf(observedType) + "; " + String.valueOf(eventType));
        }
        for (int i = 0; i < observedType.getActualTypeArguments().length; ++i) {
            if (this.parametersMatch(observedType.getActualTypeArguments()[i], eventType.getActualTypeArguments()[i])) continue;
            return false;
        }
        return true;
    }

    private boolean parametersMatch(Type observedParameter, Type eventParameter) {
        if (Types.isActualType(observedParameter) && Types.isActualType(eventParameter)) {
            return this.matches(observedParameter, eventParameter);
        }
        if (observedParameter instanceof WildcardType && eventParameter instanceof WildcardType) {
            return CovariantTypes.isAssignableFrom(observedParameter, eventParameter);
        }
        if (observedParameter instanceof WildcardType) {
            return this.parametersMatch((WildcardType)observedParameter, eventParameter);
        }
        if (observedParameter instanceof TypeVariable) {
            return this.parametersMatch((TypeVariable)observedParameter, eventParameter);
        }
        return false;
    }

    private boolean parametersMatch(TypeVariable<?> observedParameter, Type eventParameter) {
        BeanTypeAssignabilityRules.instance();
        for (Type bound : BeanTypeAssignabilityRules.getUppermostTypeVariableBounds(observedParameter)) {
            if (CovariantTypes.isAssignableFrom(bound, eventParameter)) continue;
            return false;
        }
        return true;
    }

    private boolean parametersMatch(WildcardType observedParameter, Type eventParameter) {
        return BeanTypeAssignabilityRules.instance().lowerBoundsOfWildcardMatch(eventParameter, observedParameter) && BeanTypeAssignabilityRules.instance().upperBoundsOfWildcardMatch(observedParameter, eventParameter);
    }
}

