/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.EventContextImpl;
import io.quarkus.arc.impl.EventMetadataImpl;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.ObserverMethod;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;

public interface InjectableObserverMethod<T>
extends ObserverMethod<T> {
    default public Set<Annotation> getObservedQualifiers() {
        return Collections.emptySet();
    }

    default public Reception getReception() {
        return Reception.ALWAYS;
    }

    default public TransactionPhase getTransactionPhase() {
        return TransactionPhase.IN_PROGRESS;
    }

    default public Bean<?> getDeclaringBean() {
        return this.getDeclaringBeanIdentifier() != null ? Arc.container().bean(this.getDeclaringBeanIdentifier()) : null;
    }

    default public void notify(T event) {
        this.notify(new EventContextImpl<T>(event, new EventMetadataImpl(this.getObservedQualifiers(), event.getClass(), null)));
    }

    public String getDeclaringBeanIdentifier();

    public static int compare(InjectableObserverMethod<?> o1, InjectableObserverMethod<?> o2) {
        return Integer.compare(o1.getPriority(), o2.getPriority());
    }
}

