/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.SubordinateAtomicAction;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.util.Vector;

public class SubordinateAtomicActionRecoveryModule
implements RecoveryModule {
    private boolean recoveryScanCompletedWithoutError;
    private boolean validatePosition;

    @Override
    public void periodicWorkFirstPass() {
        RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
        InputObjectState states = new InputObjectState();
        Uid uid = null;
        try {
            if (recoveryStore.allObjUids(SubordinateAtomicAction.getType(), states) && states.notempty()) {
                while ((uid = UidHelper.unpackFrom(states)).notEquals(Uid.nullUid())) {
                    SubordinationManager.getTransactionImporter().recoverTransaction(uid);
                }
            }
            this.recoveryScanCompletedWithoutError = true;
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_could_not_recover_subordinate(uid, e);
            this.recoveryScanCompletedWithoutError = false;
        }
        if (!this.validatePosition()) {
            this.recoveryScanCompletedWithoutError = false;
        }
    }

    @Override
    public void periodicWorkSecondPass() {
    }

    public boolean isRecoveryScanCompletedWithoutError() {
        return this.recoveryScanCompletedWithoutError;
    }

    private boolean validatePosition() {
        if (!this.validatePosition) {
            Vector<RecoveryModule> modules = RecoveryManager.manager().getModules();
            boolean foundSelf = false;
            for (RecoveryModule module : modules) {
                if (module instanceof SubordinateAtomicActionRecoveryModule) {
                    foundSelf = true;
                    continue;
                }
                if (!(module instanceof XARecoveryModule)) continue;
                if (!foundSelf) {
                    return false;
                }
                this.validatePosition = true;
                break;
            }
        }
        return this.validatePosition;
    }
}

