/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapperFactory;

public abstract class AbstractLDAPStorageMapperFactory
implements LDAPStorageMapperFactory<LDAPStorageMapper> {
    @Override
    public void init(Config.Scope config) {
    }

    @Override
    public LDAPStorageMapper create(KeycloakSession session, ComponentModel model) {
        String ldapProviderModelId = model.getParentId();
        LDAPStorageProvider ldapProvider = (LDAPStorageProvider)session.getAttribute(ldapProviderModelId);
        return this.createMapper(model, ldapProvider);
    }

    protected abstract AbstractLDAPStorageMapper createMapper(ComponentModel var1, LDAPStorageProvider var2);

    @Override
    public void postInit(KeycloakSessionFactory factory) {
    }

    public Map<String, Object> getTypeMetadata() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("fedToKeycloakSyncSupported", false);
        metadata.put("keycloakToFedSyncSupported", false);
        return metadata;
    }

    @Override
    public void close() {
    }

    public static ProviderConfigProperty createConfigProperty(String name, String label, String helpText, String type, List<String> options) {
        ProviderConfigProperty configProperty = new ProviderConfigProperty();
        configProperty.setName(name);
        configProperty.setLabel(label);
        configProperty.setHelpText(helpText);
        configProperty.setType(type);
        configProperty.setOptions(options);
        return configProperty;
    }

    public static ProviderConfigProperty createConfigProperty(String name, String label, String helpText, String type, List<String> options, boolean required) {
        ProviderConfigProperty property = AbstractLDAPStorageMapperFactory.createConfigProperty(name, label, helpText, type, options);
        property.setRequired(required);
        return property;
    }

    protected void checkMandatoryConfigAttribute(String name, String displayName, ComponentModel mapperModel) throws ComponentValidationException {
        String attrConfigValue = (String)mapperModel.getConfig().getFirst((Object)name);
        if (attrConfigValue == null || attrConfigValue.trim().isEmpty()) {
            throw new ComponentValidationException("Missing configuration for '" + displayName + "'", new Object[0]);
        }
    }
}

